"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMetricType = exports.isDefaultMetricType = exports.UsageMetricsResponseSchema = exports.UsageMetricsRequestSchema = exports.UsageMetricsAutoOpsResponseSchema = exports.METRIC_TYPE_VALUES = exports.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = exports.DEFAULT_METRIC_TYPES = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// note these should be sorted alphabetically as we sort the URL params on the browser side
// before making the request, else the cache key will be different and that would invoke a new request
const DEFAULT_METRIC_TYPES = exports.DEFAULT_METRIC_TYPES = ['ingest_rate', 'storage_retained'];
const METRIC_TYPE_VALUES = exports.METRIC_TYPE_VALUES = [...DEFAULT_METRIC_TYPES, 'search_vcu', 'ingest_vcu', 'ml_vcu', 'index_latency', 'index_rate', 'search_latency', 'search_rate'];
const isDefaultMetricType = metricType =>
// @ts-ignore
DEFAULT_METRIC_TYPES.includes(metricType);
exports.isDefaultMetricType = isDefaultMetricType;
const METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = exports.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = Object.freeze({
  storage_retained: 'Data Retained in Storage',
  ingest_rate: 'Data Ingested',
  search_vcu: 'Search VCU',
  ingest_vcu: 'Ingest VCU',
  ml_vcu: 'ML VCU',
  index_latency: 'Index Latency',
  index_rate: 'Index Rate',
  search_latency: 'Search Latency',
  search_rate: 'Search Rate'
});

// type guard for MetricTypes
const isMetricType = type => METRIC_TYPE_VALUES.includes(type);

// @ts-ignore
exports.isMetricType = isMetricType;
const isValidMetricType = value => METRIC_TYPE_VALUES.includes(value);
const DateSchema = _configSchema.schema.string({
  minLength: 1,
  validate: v => v.trim().length ? undefined : 'Date ISO string must not be empty'
});
const metricTypesSchema = _configSchema.schema.oneOf(
// @ts-expect-error TS2769: No overload matches this call
METRIC_TYPE_VALUES.map(metricType => _configSchema.schema.literal(metricType)) // Create a oneOf schema for the keys
);
const UsageMetricsRequestSchema = exports.UsageMetricsRequestSchema = _configSchema.schema.object({
  from: DateSchema,
  to: DateSchema,
  metricTypes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    validate: values => {
      const trimmedValues = values.map(v => v.trim());
      if (trimmedValues.some(v => !v.length)) {
        return '[metricTypes] list cannot contain empty values';
      } else if (trimmedValues.some(v => !isValidMetricType(v))) {
        return `must be one of ${METRIC_TYPE_VALUES.join(', ')}`;
      }
    }
  }),
  dataStreams: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: values => {
      if (values.map(v => v.trim()).some(v => !v.length)) {
        return 'list cannot contain empty values';
      }
    }
  })
});
const UsageMetricsResponseSchema = exports.UsageMetricsResponseSchema = {
  body: () => _configSchema.schema.object({
    metrics: _configSchema.schema.recordOf(metricTypesSchema, _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      data: _configSchema.schema.arrayOf(_configSchema.schema.object({
        x: _configSchema.schema.number(),
        y: _configSchema.schema.number()
      }))
    })))
  })
};
const UsageMetricsAutoOpsResponseSchema = exports.UsageMetricsAutoOpsResponseSchema = {
  body: () => _configSchema.schema.object({
    metrics: _configSchema.schema.recordOf(metricTypesSchema, _configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      data: _configSchema.schema.arrayOf(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
        minSize: 2,
        maxSize: 2
      }))
    })))
  })
};