"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateUrlFromDatasetQualityDetailsState = exports.getDatasetQualityDetailsStateFromUrl = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var rt = _interopRequireWildcard(require("io-ts"));
var _url_schema = require("../../../common/url_schema");
var urlSchemaV1 = _interopRequireWildcard(require("./url_schema_v1"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateUrlFromDatasetQualityDetailsState = ({
  urlStateStorageContainer,
  datasetQualityDetailsState
}) => {
  if (!datasetQualityDetailsState) {
    return;
  }
  const encodedUrlStateValues = urlSchemaV1.stateFromUntrustedUrlRT.encode(datasetQualityDetailsState);
  urlStateStorageContainer.set(_url_schema.DATA_QUALITY_URL_STATE_KEY, encodedUrlStateValues, {
    replace: true
  });
};

/*
 * This function is used to get the dataset quality details state from the URL.
 * It will return `null` if the URL state is not present or `undefined` if the URL state is present but invalid.
 */
exports.updateUrlFromDatasetQualityDetailsState = updateUrlFromDatasetQualityDetailsState;
const getDatasetQualityDetailsStateFromUrl = ({
  toastsService,
  urlStateStorageContainer
}) => {
  var _urlStateStorageConta;
  const urlStateValues = (_urlStateStorageConta = urlStateStorageContainer.get(_url_schema.DATA_QUALITY_URL_STATE_KEY)) !== null && _urlStateStorageConta !== void 0 ? _urlStateStorageConta : undefined;
  const stateValuesE = rt.union([rt.undefined, urlSchemaV1.stateFromUntrustedUrlRT]).decode(urlStateValues);
  if (Either.isLeft(stateValuesE)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _ioTsUtils.createPlainError)((0, _ioTsUtils.formatErrors)(stateValuesE.left)));
    return undefined;
  } else {
    var _stateValuesE$right;
    return (_stateValuesE$right = stateValuesE.right) !== null && _stateValuesE$right !== void 0 ? _stateValuesE$right : null;
  }
};
exports.getDatasetQualityDetailsStateFromUrl = getDatasetQualityDetailsStateFromUrl;