"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSavedQueryRoutes = registerSavedQueryRoutes;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/kibana-utils-plugin/server");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SAVED_QUERY_ID_CONFIG = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const SAVED_QUERY_ATTRS_CONFIG = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  query: _configSchema.schema.object({
    query: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.object({}, {
      unknowns: 'allow'
    })]),
    language: _configSchema.schema.string()
  }),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  timefilter: _configSchema.schema.maybe(_configSchema.schema.any())
});
const savedQueryResponseSchema = () => _configSchema.schema.object({
  id: _configSchema.schema.string(),
  attributes: SAVED_QUERY_ATTRS_CONFIG,
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const access = 'internal';
const version = '1';
function registerSavedQueryRoutes({
  http
}) {
  const router = http.createRouter();
  router.versioned.post({
    path: `${_constants.SAVED_QUERY_BASE_URL}/_is_duplicate_title`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        body: _configSchema.schema.object({
          title: _configSchema.schema.string(),
          id: _configSchema.schema.maybe(_configSchema.schema.string())
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.object({
            isDuplicate: _configSchema.schema.boolean()
          })
        }
      }
    }
  }, async (context, request, response) => {
    try {
      const savedQuery = await context.savedQuery;
      const isDuplicate = await savedQuery.isDuplicateTitle(request.body);
      return response.ok({
        body: {
          isDuplicate
        }
      });
    } catch (e) {
      var _e$output$payload, _e$output;
      const err = (_e$output$payload = (_e$output = e.output) === null || _e$output === void 0 ? void 0 : _e$output.payload) !== null && _e$output$payload !== void 0 ? _e$output$payload : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.post({
    path: `${_constants.SAVED_QUERY_BASE_URL}/_create`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        body: SAVED_QUERY_ATTRS_CONFIG
      },
      response: {
        200: {
          body: savedQueryResponseSchema
        }
      }
    }
  }, async (context, request, response) => {
    try {
      const savedQuery = await context.savedQuery;
      const body = await savedQuery.create(request.body);
      return response.ok({
        body
      });
    } catch (e) {
      var _e$output$payload2, _e$output2;
      const err = (_e$output$payload2 = (_e$output2 = e.output) === null || _e$output2 === void 0 ? void 0 : _e$output2.payload) !== null && _e$output$payload2 !== void 0 ? _e$output$payload2 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.put({
    path: `${_constants.SAVED_QUERY_BASE_URL}/{id}`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        params: SAVED_QUERY_ID_CONFIG,
        body: SAVED_QUERY_ATTRS_CONFIG
      },
      response: {
        200: {
          body: savedQueryResponseSchema
        }
      }
    }
  }, async (context, request, response) => {
    const {
      id
    } = request.params;
    try {
      const savedQuery = await context.savedQuery;
      const body = await savedQuery.update(id, request.body);
      return response.ok({
        body
      });
    } catch (e) {
      var _e$output$payload3, _e$output3;
      const err = (_e$output$payload3 = (_e$output3 = e.output) === null || _e$output3 === void 0 ? void 0 : _e$output3.payload) !== null && _e$output$payload3 !== void 0 ? _e$output$payload3 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.get({
    path: `${_constants.SAVED_QUERY_BASE_URL}/{id}`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        params: SAVED_QUERY_ID_CONFIG
      },
      response: {
        200: {
          body: savedQueryResponseSchema
        }
      }
    }
  }, async (context, request, response) => {
    const {
      id
    } = request.params;
    try {
      const savedQuery = await context.savedQuery;
      const body = await savedQuery.get(id);
      return response.ok({
        body
      });
    } catch (e) {
      var _e$output$payload4, _e$output4;
      const err = (_e$output$payload4 = (_e$output4 = e.output) === null || _e$output4 === void 0 ? void 0 : _e$output4.payload) !== null && _e$output$payload4 !== void 0 ? _e$output$payload4 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.get({
    path: `${_constants.SAVED_QUERY_BASE_URL}/_count`,
    access
  }).addVersion({
    version,
    validate: {
      request: {},
      response: {
        200: {
          body: () => _configSchema.schema.number()
        }
      }
    }
  }, async (context, request, response) => {
    try {
      const savedQuery = await context.savedQuery;
      const count = await savedQuery.count();
      return response.ok({
        body: `${count}`
      });
    } catch (e) {
      var _e$output$payload5, _e$output5;
      const err = (_e$output$payload5 = (_e$output5 = e.output) === null || _e$output5 === void 0 ? void 0 : _e$output5.payload) !== null && _e$output$payload5 !== void 0 ? _e$output$payload5 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.post({
    path: `${_constants.SAVED_QUERY_BASE_URL}/_find`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        body: _configSchema.schema.object({
          search: _configSchema.schema.string({
            defaultValue: ''
          }),
          perPage: _configSchema.schema.number({
            defaultValue: 50
          }),
          page: _configSchema.schema.number({
            defaultValue: 1
          })
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.object({
            total: _configSchema.schema.number(),
            savedQueries: _configSchema.schema.arrayOf(savedQueryResponseSchema())
          })
        }
      }
    }
  }, async (context, request, response) => {
    try {
      const savedQuery = await context.savedQuery;
      const body = await savedQuery.find(request.body);
      return response.ok({
        body
      });
    } catch (e) {
      var _e$output$payload6, _e$output6;
      const err = (_e$output$payload6 = (_e$output6 = e.output) === null || _e$output6 === void 0 ? void 0 : _e$output6.payload) !== null && _e$output$payload6 !== void 0 ? _e$output$payload6 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
  router.versioned.delete({
    path: `${_constants.SAVED_QUERY_BASE_URL}/{id}`,
    access
  }).addVersion({
    version,
    validate: {
      request: {
        params: SAVED_QUERY_ID_CONFIG
      },
      response: {
        200: {
          body: () => _configSchema.schema.never()
        }
      }
    }
  }, async (context, request, response) => {
    const {
      id
    } = request.params;
    try {
      const savedQuery = await context.savedQuery;
      await savedQuery.delete(id);
      return response.ok();
    } catch (e) {
      var _e$output$payload7, _e$output7;
      const err = (_e$output$payload7 = (_e$output7 = e.output) === null || _e$output7 === void 0 ? void 0 : _e$output7.payload) !== null && _e$output$payload7 !== void 0 ? _e$output$payload7 : e;
      return (0, _server.reportServerError)(response, err);
    }
  });
}