"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SearchSessionName = ({
  name,
  editName
}) => {
  const [isEditing, setIsEditing] = _react.default.useState(false);
  const [newName, setNewName] = _react.default.useState(name);
  const [isSaving, setIsSaving] = _react.default.useState(false);
  const isNewNameValid = !!newName;
  (0, _react.useEffect)(() => {
    if (!isEditing) {
      setNewName(name);
    }
  }, [isEditing, name]);
  return !isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    responsive: false,
    alignItems: 'center',
    justifyContent: 'spaceBetween',
    gutterSize: 'none'
    // padding to align with compressed input size
    ,
    style: {
      paddingTop: 4,
      paddingBottom: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    className: 'eui-textTruncate'
  }, /*#__PURE__*/_react.default.createElement("h4", {
    className: 'eui-textTruncate'
  }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    autoFocus: true,
    iconType: 'pencil',
    color: 'text',
    "aria-label": _i18n.i18n.translate('data.searchSessionName.editAriaLabelText', {
      defaultMessage: 'Edit search session name'
    }),
    "data-test-subj": 'searchSessionNameEdit',
    onClick: () => setIsEditing(true)
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    compressed: true,
    placeholder: _i18n.i18n.translate('data.searchSessionName.placeholderText', {
      defaultMessage: 'Enter a name for the search session'
    }),
    value: newName,
    onChange: e => {
      setNewName(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('data.searchSessionName.ariaLabelText', {
      defaultMessage: 'Search session name'
    }),
    "data-test-subj": 'searchSessionNameInput',
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: 'xs',
      color: 'text',
      onClick: async () => {
        if (!isNewNameValid) return;
        if (newName !== name && editName) {
          setIsSaving(true);
          try {
            await editName(newName);
          } catch (e) {
            // handled by the service
          }
        }
        setIsSaving(false);
        setIsEditing(false);
      },
      disabled: !isNewNameValid,
      isLoading: isSaving,
      "data-test-subj": 'searchSessionNameSave'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.searchSessionName.saveButtonText",
      defaultMessage: "Save"
    }))
  });
};
exports.SearchSessionName = SearchSessionName;