"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsPreference = getEsPreference;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultSessionId = `${Date.now()}`;
function getEsPreference(uiSettings, sessionId = defaultSessionId) {
  const setPreference = uiSettings.get(_common.UI_SETTINGS.COURIER_SET_REQUEST_PREFERENCE);
  if (setPreference === 'sessionId') return `${sessionId}`;
  const customPreference = uiSettings.get(_common.UI_SETTINGS.COURIER_CUSTOM_REQUEST_PREFERENCE);
  return setPreference === 'custom' ? customPreference : undefined;
}