"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./index.scss");
var _public = require("@kbn/kibana-utils-plugin/public");
var _search_service = require("./search/search_service");
var _query = require("./query");
var _services = require("./services");
var _actions = require("./actions");
var _triggers = require("./triggers");
var _table_inspector_view = require("./utils/table_inspector_view");
var _now_provider = require("./now_provider");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DataPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "searchService", void 0);
    (0, _defineProperty2.default)(this, "queryService", void 0);
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "nowProvider", void 0);
    this.searchService = new _search_service.SearchService(initializerContext);
    this.queryService = new _query.QueryService(initializerContext.config.get().query.timefilter.minRefreshInterval);
    this.storage = new _public.Storage(window.localStorage);
    this.nowProvider = new _now_provider.NowProvider();
  }
  setup(core, {
    bfetch,
    expressions,
    uiActions,
    usageCollection,
    inspector,
    fieldFormats,
    management
  }) {
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    (0, _services.setTheme)(core.theme);
    const searchService = this.searchService.setup(core, {
      bfetch,
      usageCollection,
      expressions,
      management,
      nowProvider: this.nowProvider
    });
    const queryService = this.queryService.setup({
      uiSettings: core.uiSettings,
      storage: this.storage,
      nowProvider: this.nowProvider
    });
    uiActions.registerTrigger(_triggers.applyFilterTrigger);
    inspector.registerView((0, _table_inspector_view.getTableViewDescription)(() => ({
      uiActions: startServices().plugins.uiActions,
      uiSettings: startServices().core.uiSettings,
      fieldFormats: startServices().self.fieldFormats,
      isFilterable: startServices().self.datatableUtilities.isFilterable
    })));
    fieldFormats.register((0, _common.getAggsFormats)(serializedFieldFormat => startServices().plugins.fieldFormats.deserialize(serializedFieldFormat)));
    return {
      search: searchService,
      query: queryService
    };
  }
  start(core, {
    uiActions,
    fieldFormats,
    dataViews,
    inspector,
    screenshotMode
  }) {
    const {
      uiSettings,
      overlays
    } = core;
    (0, _services.setOverlays)(overlays);
    (0, _services.setUiSettings)(uiSettings);
    (0, _services.setIndexPatterns)(dataViews);
    const query = this.queryService.start({
      storage: this.storage,
      http: core.http,
      uiSettings
    });
    const search = this.searchService.start(core, {
      fieldFormats,
      indexPatterns: dataViews,
      inspector,
      screenshotMode,
      scriptedFieldsEnabled: dataViews.scriptedFieldsEnabled
    });
    (0, _services.setSearchService)(search);
    uiActions.addTriggerAction('SELECT_RANGE_TRIGGER', (0, _actions.createSelectRangeActionDefinition)(() => ({
      uiActions
    })));
    uiActions.addTriggerAction('VALUE_CLICK_TRIGGER', (0, _actions.createValueClickActionDefinition)(() => ({
      uiActions
    })));
    uiActions.addTriggerAction('MULTI_VALUE_CLICK_TRIGGER', (0, _actions.createMultiValueClickActionDefinition)(() => ({
      query
    })));
    const datatableUtilities = new _common.DatatableUtilitiesService(search.aggs, dataViews, fieldFormats);
    const dataServices = {
      actions: {
        createFiltersFromValueClickAction: _actions.createFiltersFromValueClickAction,
        createFiltersFromRangeSelectAction: _actions.createFiltersFromRangeSelectAction,
        createFiltersFromMultiValueClickAction: _actions.createFiltersFromMultiValueClickAction
      },
      datatableUtilities,
      fieldFormats,
      indexPatterns: dataViews,
      dataViews,
      query,
      search,
      nowProvider: this.nowProvider
    };
    return dataServices;
  }
  stop() {
    this.queryService.stop();
    this.searchService.stop();
  }
}
exports.DataPublicPlugin = DataPublicPlugin;