"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRunningResponse = exports.isAbortResponse = exports.getUserTimeZone = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO - investigate if this check is still needed
// There are no documented work flows where response or rawResponse is not returned
// Leaving check to prevent breaking changes until full investigation can be completed.
/**
 * @returns true if response is abort
 */
const isAbortResponse = response => {
  return !response || !response.rawResponse;
};

/**
 * @returns true if request is still running
 */
exports.isAbortResponse = isAbortResponse;
const isRunningResponse = response => {
  var _response$isRunning;
  return (_response$isRunning = response === null || response === void 0 ? void 0 : response.isRunning) !== null && _response$isRunning !== void 0 ? _response$isRunning : false;
};
exports.isRunningResponse = isRunningResponse;
const getUserTimeZone = (getConfig, shouldDetectTimezone = true) => {
  const defaultTimeZone = 'UTC';
  const userTimeZone = getConfig('dateFormat:tz');
  if (userTimeZone === 'Browser') {
    if (!shouldDetectTimezone) {
      return defaultTimeZone;
    }

    // If the typeMeta data index template does not have a timezone assigned to the selected field, use the configured tz
    const detectedTimezone = _momentTimezone.default.tz.guess();
    const tzOffset = (0, _momentTimezone.default)().format('Z');
    return detectedTimezone || tzOffset;
  }
  return userTimeZone !== null && userTimeZone !== void 0 ? userTimeZone : defaultTimeZone;
};
exports.getUserTimeZone = getUserTimeZone;