"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreference = getPreference;
exports.getSearchParams = getSearchParams;
exports.getSearchParamsFromRequest = getSearchParamsFromRequest;
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sessionId = Date.now();
function getSearchParams(getConfig) {
  return {
    preference: getPreference(getConfig)
  };
}
function getPreference(getConfig) {
  const setRequestPreference = getConfig(_constants.UI_SETTINGS.COURIER_SET_REQUEST_PREFERENCE);
  if (setRequestPreference === 'sessionId') return sessionId;
  return setRequestPreference === 'custom' ? getConfig(_constants.UI_SETTINGS.COURIER_CUSTOM_REQUEST_PREFERENCE) : undefined;
}

/** @public */
// TODO: Could provide this on runtime contract with dependencies
// already wired up.
function getSearchParamsFromRequest(searchRequest, dependencies) {
  var _dataView$title;
  const {
    getConfig
  } = dependencies;
  const searchParams = getSearchParams(getConfig);
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    track_total_hits,
    ...body
  } = searchRequest.body;
  const dataView = typeof searchRequest.index !== 'string' ? searchRequest.index : undefined;
  const index = (_dataView$title = dataView === null || dataView === void 0 ? void 0 : dataView.title) !== null && _dataView$title !== void 0 ? _dataView$title : `${searchRequest.index}`;
  return {
    index,
    body,
    // @ts-ignore
    track_total_hits,
    ...((dataView === null || dataView === void 0 ? void 0 : dataView.getAllowHidden()) && {
      expand_wildcards: 'all'
    }),
    ...searchParams
  };
}