"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiFieldKey = exports.MULTI_FIELD_KEY_SEPARATOR = void 0;
exports.isMultiFieldKey = isMultiFieldKey;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const id = Symbol('id');
const isBucketLike = bucket => {
  return Boolean(bucket && typeof bucket === 'object' && 'key' in bucket);
};
function getKeysFromBucket(bucket) {
  if (!isBucketLike(bucket)) {
    throw new Error('bucket malformed - no key found');
  }
  return Array.isArray(bucket.key) ? bucket.key.map(keyPart => String(keyPart)) : [String(bucket.key)];
}
class MultiFieldKey {
  constructor(bucket) {
    (0, _defineProperty2.default)(this, id, void 0);
    (0, _defineProperty2.default)(this, "keys", void 0);
    this.keys = getKeysFromBucket(bucket);
    this[id] = MultiFieldKey.idBucket(bucket);
  }
  static idBucket(bucket) {
    return getKeysFromBucket(bucket).join(',');
  }
  toString() {
    return this[id];
  }
}
exports.MultiFieldKey = MultiFieldKey;
function isMultiFieldKey(field) {
  return field instanceof MultiFieldKey;
}

/**
 * Multi-field key separator used in Visualizations (Lens, AggBased, TSVB).
 * This differs from the separator used in the toString method of the MultiFieldKey
 */
const MULTI_FIELD_KEY_SEPARATOR = exports.MULTI_FIELD_KEY_SEPARATOR = ' › ';