"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textBasedQueryStateToAstWithValidation = textBasedQueryStateToAstWithValidation;
var _esQuery = require("@kbn/es-query");
var _text_based_query_state_to_ast = require("./text_based_query_state_to_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Converts QueryState to expression AST
 * @param filters array of kibana filters
 * @param query kibana query or aggregate query
 * @param inputQuery
 * @param time kibana time range
 * @param dataView
 * @param titleForInspector
 * @param descriptionForInspector
 */
async function textBasedQueryStateToAstWithValidation({
  filters,
  query,
  inputQuery,
  time,
  dataView,
  titleForInspector,
  descriptionForInspector
}) {
  let ast;
  if (query && (0, _esQuery.isOfAggregateQueryType)(query)) {
    ast = (0, _text_based_query_state_to_ast.textBasedQueryStateToExpressionAst)({
      filters,
      query,
      inputQuery,
      time,
      timeFieldName: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName,
      titleForInspector,
      descriptionForInspector
    });
  }
  return ast;
}