"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LINE_FEED_CHARACTER = exports.CSV_MIME_TYPE = void 0;
exports.datatableToCSV = datatableToCSV;
var _escape_value = require("./escape_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Inspired by the inspector CSV exporter

const LINE_FEED_CHARACTER = exports.LINE_FEED_CHARACTER = '\r\n';
const CSV_MIME_TYPE = exports.CSV_MIME_TYPE = 'text/plain;charset=utf-8';
function datatableToCSV({
  columns,
  rows
}, {
  csvSeparator,
  quoteValues,
  formatFactory,
  raw,
  escapeFormulaValues,
  columnsSorting
}) {
  const escapeValues = (0, _escape_value.createEscapeValue)({
    separator: csvSeparator,
    quoteValues,
    escapeFormulaValues
  });
  const sortedIds = columnsSorting || columns.map(col => col.id);

  // Build an index lookup table
  const columnIndexLookup = sortedIds.reduce((memo, id, index) => {
    memo[id] = index;
    return memo;
  }, {});

  // Build the header row by its names
  const header = [];
  const sortedColumnIds = [];
  const formatters = {};
  for (const column of columns) {
    var _column$meta;
    const columnIndex = columnIndexLookup[column.id];
    header[columnIndex] = escapeValues(column.name);
    sortedColumnIds[columnIndex] = column.id;
    formatters[column.id] = formatFactory((_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.params);
  }
  if (header.length === 0) {
    return '';
  }

  // Convert the array of row objects to an array of row arrays
  const csvRows = rows.map(row => {
    return sortedColumnIds.map(id => escapeValues(raw ? row[id] : formatters[id].convert(row[id])));
  });
  return [header, ...csvRows].map(row => row.join(csvSeparator)).join(LINE_FEED_CHARACTER) + LINE_FEED_CHARACTER; // Add \r\n after last line
}