"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.dashboardSavedObjectSchema = exports.dashboardAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _v = require("../v1");
var _serviceDefinitionV1$, _serviceDefinitionV1$2, _serviceDefinitionV1$3;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const dashboardAttributesSchema = exports.dashboardAttributesSchema = _v.dashboardAttributesSchema.extends({
  controlGroupInput: _configSchema.schema.maybe(_v.controlGroupInputSchema.extends({
    showApplySelections: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }, {
    unknowns: 'ignore'
  }))
}, {
  unknowns: 'ignore'
});
const dashboardSavedObjectSchema = exports.dashboardSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(dashboardAttributesSchema);

// Content management service definition.
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      ...(_v.serviceDefinition === null || _v.serviceDefinition === void 0 ? void 0 : (_serviceDefinitionV1$ = _v.serviceDefinition.create) === null || _serviceDefinitionV1$ === void 0 ? void 0 : _serviceDefinitionV1$.in),
      data: {
        schema: dashboardAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      ...((_serviceDefinitionV1$2 = _v.serviceDefinition.update) === null || _serviceDefinitionV1$2 === void 0 ? void 0 : _serviceDefinitionV1$2.in),
      data: {
        schema: dashboardAttributesSchema
      }
    }
  },
  search: {
    in: (_serviceDefinitionV1$3 = _v.serviceDefinition.search) === null || _serviceDefinitionV1$3 === void 0 ? void 0 : _serviceDefinitionV1$3.in
  },
  mSearch: {
    out: {
      result: {
        schema: dashboardSavedObjectSchema
      }
    }
  }
};