"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardContentManagementCache = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lruCache = _interopRequireDefault(require("lru-cache"));
var _dashboard_constants = require("../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DashboardContentManagementCache {
  constructor() {
    (0, _defineProperty2.default)(this, "cache", void 0);
    this.cache = new _lruCache.default({
      max: _dashboard_constants.DASHBOARD_CACHE_SIZE,
      maxAge: _dashboard_constants.DASHBOARD_CACHE_TTL
    });
  }

  /** Fetch the dashboard with `id` from the cache */
  fetchDashboard(id) {
    return this.cache.get(id);
  }

  /** Add the fetched dashboard to the cache */
  addDashboard({
    item: dashboard,
    meta
  }) {
    this.cache.set(dashboard.id, {
      meta,
      item: dashboard
    });
  }

  /** Delete the dashboard with `id` from the cache */
  deleteDashboard(id) {
    this.cache.del(id);
  }
}
exports.DashboardContentManagementCache = DashboardContentManagementCache;