"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardBackupService = exports.PANELS_CONTROL_GROUP_KEY = exports.DASHBOARD_PANELS_UNSAVED_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _dashboard_container_strings = require("../dashboard_container/_dashboard_container_strings");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_PANELS_UNSAVED_ID = exports.DASHBOARD_PANELS_UNSAVED_ID = 'unsavedDashboard';
const PANELS_CONTROL_GROUP_KEY = exports.PANELS_CONTROL_GROUP_KEY = 'controlGroup';
const DASHBOARD_PANELS_SESSION_KEY = 'dashboardPanels';
const DASHBOARD_VIEWMODE_LOCAL_KEY = 'dashboardViewMode';

// this key is named `panels` for BWC reasons, but actually contains the entire dashboard state
const DASHBOARD_STATE_SESSION_KEY = 'dashboardStateManagerPanels';
class DashboardBackupService {
  constructor() {
    (0, _defineProperty2.default)(this, "activeSpaceId", void 0);
    (0, _defineProperty2.default)(this, "sessionStorage", void 0);
    (0, _defineProperty2.default)(this, "localStorage", void 0);
    (0, _defineProperty2.default)(this, "oldDashboardsWithUnsavedChanges", []);
    (0, _defineProperty2.default)(this, "getViewMode", () => {
      return this.localStorage.get(DASHBOARD_VIEWMODE_LOCAL_KEY);
    });
    (0, _defineProperty2.default)(this, "storeViewMode", viewMode => {
      try {
        this.localStorage.set(DASHBOARD_VIEWMODE_LOCAL_KEY, viewMode);
      } catch (e) {
        _kibana_services.coreServices.notifications.toasts.addDanger({
          title: _dashboard_container_strings.backupServiceStrings.viewModeStorageError(e.message),
          'data-test-subj': 'dashboardViewmodeBackupFailure'
        });
      }
    });
    this.sessionStorage = new _public2.Storage(sessionStorage);
    this.localStorage = new _public2.Storage(localStorage);
    this.activeSpaceId = 'default';
    if (_kibana_services.spacesService) {
      (0, _rxjs.firstValueFrom)(_kibana_services.spacesService.getActiveSpace$()).then(space => {
        this.activeSpaceId = space.id;
      });
    }
  }
  clearState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$, _this$sessionStorage$2, _this$sessionStorage$3, _this$sessionStorage$4;
      const dashboardStateStorage = (_this$sessionStorage$ = (_this$sessionStorage$2 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$2 === void 0 ? void 0 : _this$sessionStorage$2[this.activeSpaceId]) !== null && _this$sessionStorage$ !== void 0 ? _this$sessionStorage$ : {};
      if (dashboardStateStorage[id]) {
        delete dashboardStateStorage[id];
        this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, {
          [this.activeSpaceId]: dashboardStateStorage
        });
      }
      const panelsStorage = (_this$sessionStorage$3 = (_this$sessionStorage$4 = this.sessionStorage.get(DASHBOARD_PANELS_SESSION_KEY)) === null || _this$sessionStorage$4 === void 0 ? void 0 : _this$sessionStorage$4[this.activeSpaceId]) !== null && _this$sessionStorage$3 !== void 0 ? _this$sessionStorage$3 : {};
      if (panelsStorage[id]) {
        delete panelsStorage[id];
        this.sessionStorage.set(DASHBOARD_PANELS_SESSION_KEY, {
          [this.activeSpaceId]: panelsStorage
        });
      }
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_container_strings.backupServiceStrings.getPanelsClearError(e.message),
        'data-test-subj': 'dashboardPanelsClearFailure'
      });
    }
  }
  getState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$5, _this$sessionStorage$6, _this$sessionStorage$7, _this$sessionStorage$8;
      const dashboardState = (_this$sessionStorage$5 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$5 === void 0 ? void 0 : (_this$sessionStorage$6 = _this$sessionStorage$5[this.activeSpaceId]) === null || _this$sessionStorage$6 === void 0 ? void 0 : _this$sessionStorage$6[id];
      const panels = (_this$sessionStorage$7 = this.sessionStorage.get(DASHBOARD_PANELS_SESSION_KEY)) === null || _this$sessionStorage$7 === void 0 ? void 0 : (_this$sessionStorage$8 = _this$sessionStorage$7[this.activeSpaceId]) === null || _this$sessionStorage$8 === void 0 ? void 0 : _this$sessionStorage$8[id];
      return {
        dashboardState,
        panels
      };
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_container_strings.backupServiceStrings.getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
    }
  }
  setState(id = DASHBOARD_PANELS_UNSAVED_ID, newState, unsavedPanels) {
    try {
      var _this$sessionStorage$9, _this$sessionStorage$10;
      const dashboardStateStorage = (_this$sessionStorage$9 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) !== null && _this$sessionStorage$9 !== void 0 ? _this$sessionStorage$9 : {};
      (0, _saferLodashSet.set)(dashboardStateStorage, [this.activeSpaceId, id], newState);
      this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, dashboardStateStorage);
      const panelsStorage = (_this$sessionStorage$10 = this.sessionStorage.get(DASHBOARD_PANELS_SESSION_KEY)) !== null && _this$sessionStorage$10 !== void 0 ? _this$sessionStorage$10 : {};
      (0, _saferLodashSet.set)(panelsStorage, [this.activeSpaceId, id], unsavedPanels);
      this.sessionStorage.set(DASHBOARD_PANELS_SESSION_KEY, panelsStorage, true);
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_container_strings.backupServiceStrings.getPanelsSetError(e.message),
        'data-test-subj': 'dashboardPanelsSetFailure'
      });
    }
  }
  getDashboardIdsWithUnsavedChanges() {
    try {
      var _this$sessionStorage$11, _this$sessionStorage$12, _this$sessionStorage$13, _this$sessionStorage$14;
      const dashboardStatesInSpace = (_this$sessionStorage$11 = (_this$sessionStorage$12 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$12 === void 0 ? void 0 : _this$sessionStorage$12[this.activeSpaceId]) !== null && _this$sessionStorage$11 !== void 0 ? _this$sessionStorage$11 : {};
      const panelStatesInSpace = (_this$sessionStorage$13 = (_this$sessionStorage$14 = this.sessionStorage.get(DASHBOARD_PANELS_SESSION_KEY)) === null || _this$sessionStorage$14 === void 0 ? void 0 : _this$sessionStorage$14[this.activeSpaceId]) !== null && _this$sessionStorage$13 !== void 0 ? _this$sessionStorage$13 : {};
      const dashboardsSet = new Set();
      [...Object.keys(panelStatesInSpace), ...Object.keys(dashboardStatesInSpace)].map(dashboardId => {
        if (dashboardStatesInSpace[dashboardId].viewMode === _public.ViewMode.EDIT && (Object.keys(dashboardStatesInSpace[dashboardId]).some(stateKey => stateKey !== 'viewMode') || Object.keys(panelStatesInSpace === null || panelStatesInSpace === void 0 ? void 0 : panelStatesInSpace[dashboardId]).length > 0)) dashboardsSet.add(dashboardId);
      });
      const dashboardsWithUnsavedChanges = [...dashboardsSet];

      /**
       * Because we are storing these unsaved dashboard IDs in React component state, we only want things to be re-rendered
       * if the **contents** change, not if the array reference changes
       */
      if (!(0, _lodash.isEqual)(this.oldDashboardsWithUnsavedChanges, dashboardsWithUnsavedChanges)) {
        this.oldDashboardsWithUnsavedChanges = dashboardsWithUnsavedChanges;
      }
      return this.oldDashboardsWithUnsavedChanges;
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_container_strings.backupServiceStrings.getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
      return [];
    }
  }
  dashboardHasUnsavedEdits(id = DASHBOARD_PANELS_UNSAVED_ID) {
    return this.getDashboardIdsWithUnsavedChanges().indexOf(id) !== -1;
  }
}
let dashboardBackupService;
const getDashboardBackupService = () => {
  if (!dashboardBackupService) {
    dashboardBackupService = new DashboardBackupService();
  }
  return dashboardBackupService;
};
exports.getDashboardBackupService = getDashboardBackupService;