"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalDashboardTopNav = InternalDashboardTopNav;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/presentation-util-plugin/public");
var _common = require("../../common");
var _use_dashboard_api = require("../dashboard_api/use_dashboard_api");
var _dashboard_app_strings = require("../dashboard_app/_dashboard_app_strings");
var _dashboard_mount_context = require("../dashboard_app/hooks/dashboard_mount_context");
var _dashboard_editing_toolbar = require("../dashboard_app/top_nav/dashboard_editing_toolbar");
var _use_dashboard_menu_items = require("../dashboard_app/top_nav/use_dashboard_menu_items");
var _dashboard_constants = require("../dashboard_constants");
var _api = require("../dashboard_container/embeddable/api");
var _dashboard_recently_accessed_service = require("../services/dashboard_recently_accessed_service");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
require("./_dashboard_top_nav.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LabsFlyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
function InternalDashboardTopNav({
  customLeadingBreadCrumbs = [],
  embedSettings,
  forceHideUnifiedSearch,
  redirectTo,
  setCustomHeaderActionMenu,
  showBorderBottom = true,
  showResetChange = true
}) {
  const [isChromeVisible, setIsChromeVisible] = (0, _react.useState)(false);
  const [isLabsShown, setIsLabsShown] = (0, _react.useState)(false);
  const dashboardTitleRef = (0, _react.useRef)(null);
  const isLabsEnabled = (0, _react.useMemo)(() => _kibana_services.coreServices.uiSettings.get(_common.UI_SETTINGS.ENABLE_LABS_UI), []);
  const {
    setHeaderActionMenu,
    onAppLeave
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [allDataViews, focusedPanelId, fullScreenMode, hasRunMigrations, hasUnsavedChanges, lastSavedId, managed, query, title, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.dataViews, dashboardApi.focusedPanelId$, dashboardApi.fullScreenMode$, dashboardApi.hasRunMigrations$, dashboardApi.hasUnsavedChanges$, dashboardApi.savedObjectId, dashboardApi.managed$, dashboardApi.query$, dashboardApi.panelTitle, dashboardApi.viewMode);
  const [savedQueryId, setSavedQueryId] = (0, _react.useState)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const dashboardTitle = (0, _react.useMemo)(() => {
    return (0, _dashboard_app_strings.getDashboardTitle)(title, viewMode, !lastSavedId);
  }, [title, viewMode, lastSavedId]);

  /**
   * focus on the top header when title or view mode is changed
   */
  (0, _react.useEffect)(() => {
    var _dashboardTitleRef$cu;
    (_dashboardTitleRef$cu = dashboardTitleRef.current) === null || _dashboardTitleRef$cu === void 0 ? void 0 : _dashboardTitleRef$cu.focus();
  }, [title, viewMode]);

  /*
   * Manage chrome visibility when dashboard is in print mode.
   */
  (0, _react.useEffect)(() => {
    if (!embedSettings && viewMode === 'print') _kibana_services.coreServices.chrome.setIsVisible(false);
  }, [embedSettings, viewMode]);

  /**
   * populate recently accessed, and set is chrome visible.
   */
  (0, _react.useEffect)(() => {
    const subscription = _kibana_services.coreServices.chrome.getIsVisible$().subscribe(visible => setIsChromeVisible(visible));
    if (lastSavedId && title) {
      const fullEditPath = (0, _dashboard_constants.getFullEditPath)(lastSavedId, viewMode === 'edit');
      _kibana_services.coreServices.chrome.recentlyAccessed.add(fullEditPath, title, lastSavedId);
      (0, _dashboard_recently_accessed_service.getDashboardRecentlyAccessedService)().add(fullEditPath, title, lastSavedId); // used to sort the listing table
    }
    return () => subscription.unsubscribe();
  }, [lastSavedId, viewMode, title]);

  /**
   * Set breadcrumbs to dashboard title when dashboard's title or view mode changes
   */
  (0, _react.useEffect)(() => {
    const dashboardTitleBreadcrumbs = [{
      text: viewMode === 'edit' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "pencil",
        className: "dshTitleBreadcrumbs__updateIcon",
        onClick: () => (0, _api.openSettingsFlyout)(dashboardApi)
      })) : dashboardTitle
    }];
    if (_kibana_services.serverlessService) {
      // set serverless breadcrumbs if available,
      // set only the dashboardTitleBreadcrumbs because the main breadcrumbs automatically come as part of the navigation config
      _kibana_services.serverlessService.setBreadcrumbs(dashboardTitleBreadcrumbs);
    } else {
      /**
       * non-serverless regular breadcrumbs
       * Dashboard embedded in other plugins (e.g. SecuritySolution)
       * will have custom leading breadcrumbs for back to their app.
       **/
      _kibana_services.coreServices.chrome.setBreadcrumbs(customLeadingBreadCrumbs.concat([{
        text: (0, _dashboard_app_strings.getDashboardBreadcrumb)(),
        'data-test-subj': 'dashboardListingBreadcrumb',
        onClick: () => {
          redirectTo({
            destination: 'listing'
          });
        }
      }, ...dashboardTitleBreadcrumbs]), {
        project: {
          value: dashboardTitleBreadcrumbs
        }
      });
    }
  }, [redirectTo, dashboardTitle, dashboardApi, viewMode, customLeadingBreadCrumbs]);

  /**
   * Build app leave handler whenever hasUnsavedChanges changes
   */
  (0, _react.useEffect)(() => {
    onAppLeave(actions => {
      return actions.default();
    });
    return () => {
      // reset on app leave handler so leaving from the listing page doesn't trigger a confirmation
      onAppLeave(actions => actions.default());
    };
  }, [onAppLeave, hasUnsavedChanges, viewMode]);
  const visibilityProps = (0, _react.useMemo)(() => {
    const shouldShowNavBarComponent = forceShow => (forceShow || isChromeVisible) && !fullScreenMode;
    const shouldShowFilterBar = forceHide => !forceHide && (_kibana_services.dataService.query.filterManager.getFilters().length > 0 || !fullScreenMode);
    const showTopNavMenu = shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowTopNavMenu));
    const showQueryInput = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean((embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowQueryInput) || viewMode === 'edit'));
    const showDatePicker = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowDatePicker));
    const showFilterBar = shouldShowFilterBar(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceHideFilterBar));
    const showQueryBar = showQueryInput || showDatePicker || showFilterBar;
    const showSearchBar = showQueryBar || showFilterBar;
    return {
      showTopNavMenu,
      showSearchBar,
      showFilterBar,
      showQueryInput,
      showDatePicker
    };
  }, [embedSettings, forceHideUnifiedSearch, fullScreenMode, isChromeVisible, viewMode]);
  const maybeRedirect = (0, _react.useCallback)(result => {
    if (!result) return;
    const {
      redirectRequired,
      id
    } = result;
    if (redirectRequired) {
      redirectTo({
        id,
        editMode: true,
        useReplace: true,
        destination: 'dashboard'
      });
    }
  }, [redirectTo]);
  const {
    viewModeTopNavConfig,
    editModeTopNavConfig
  } = (0, _use_dashboard_menu_items.useDashboardMenuItems)({
    isLabsShown,
    setIsLabsShown,
    maybeRedirect,
    showResetChange
  });
  (0, _useUnmount.default)(() => {
    dashboardApi.clearOverlays();
  });
  const badges = (0, _react.useMemo)(() => {
    const allBadges = [];
    if (hasUnsavedChanges && viewMode === 'edit') {
      allBadges.push({
        'data-test-subj': 'dashboardUnsavedChangesBadge',
        badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeText(),
        title: '',
        color: '#F6E58D',
        toolTipProps: {
          content: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeToolTipContent(),
          position: 'bottom'
        }
      });
    }
    if (hasRunMigrations && viewMode === 'edit') {
      allBadges.push({
        'data-test-subj': 'dashboardSaveRecommendedBadge',
        badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getHasRunMigrationsText(),
        title: '',
        color: 'success',
        iconType: 'save',
        toolTipProps: {
          content: _dashboard_app_strings.unsavedChangesBadgeStrings.getHasRunMigrationsToolTipContent(),
          position: 'bottom'
        }
      });
    }
    const {
      showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    if (showWriteControls && managed) {
      const badgeProps = {
        ...(0, _managedContentBadge.getManagedContentBadge)(_dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel()),
        onClick: () => setIsPopoverOpen(!isPopoverOpen),
        onClickAriaLabel: _dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel(),
        iconOnClick: () => setIsPopoverOpen(!isPopoverOpen),
        iconOnClickAriaLabel: _dashboard_app_strings.dashboardManagedBadge.getBadgeAriaLabel()
      };
      allBadges.push({
        renderCustomBadge: ({
          badgeText
        }) => {
          const badgeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, badgeProps, badgeText);
          return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
            button: badgeButton,
            isOpen: isPopoverOpen,
            closePopover: () => setIsPopoverOpen(false),
            panelStyle: {
              maxWidth: 250
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "dashboard.managedContentPopoverButton",
            defaultMessage: "Elastic manages this dashboard. {Duplicate} it to make changes.",
            values: {
              Duplicate: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                id: "dashboardManagedContentPopoverButton",
                onClick: () => {
                  dashboardApi.runInteractiveSave(viewMode).then(result => maybeRedirect(result));
                },
                "aria-label": _dashboard_app_strings.dashboardManagedBadge.getDuplicateButtonAriaLabel()
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "dashboard.managedContentPopoverButtonText",
                defaultMessage: "Duplicate"
              }))
            }
          }));
        },
        badgeText: badgeProps.badgeText
      });
    }
    return allBadges;
  }, [hasUnsavedChanges, viewMode, hasRunMigrations, managed, isPopoverOpen, dashboardApi, maybeRedirect]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboardTopNav"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "dashboardTitle",
    className: "euiScreenReaderOnly",
    ref: dashboardTitleRef,
    tabIndex: -1
  }, `${(0, _dashboard_app_strings.getDashboardBreadcrumb)()} - ${dashboardTitle}`), /*#__PURE__*/_react.default.createElement(_kibana_services.navigationService.ui.TopNavMenu, (0, _extends2.default)({}, visibilityProps, {
    query: query,
    badges: badges,
    screenTitle: title,
    useDefaultBehaviors: true,
    savedQueryId: savedQueryId,
    indexPatterns: allDataViews !== null && allDataViews !== void 0 ? allDataViews : [],
    saveQueryMenuVisibility: (0, _get_dashboard_capabilities.getDashboardCapabilities)().saveQuery ? 'allowed_by_app_privilege' : 'globally_managed',
    appName: _dashboard_constants.LEGACY_DASHBOARD_APP_ID,
    visible: viewMode !== 'print',
    setMenuMountPoint: embedSettings || fullScreenMode ? setCustomHeaderActionMenu !== null && setCustomHeaderActionMenu !== void 0 ? setCustomHeaderActionMenu : undefined : setHeaderActionMenu,
    className: fullScreenMode ? 'kbnTopNavMenu-isFullScreen' : undefined,
    config: visibilityProps.showTopNavMenu ? viewMode === 'edit' ? editModeTopNavConfig : viewModeTopNavConfig : undefined,
    onQuerySubmit: (_payload, isUpdate) => {
      if (isUpdate === false) {
        dashboardApi.forceRefresh();
      }
    },
    onSavedQueryIdChange: setSavedQueryId
  })), viewMode !== 'print' && isLabsEnabled && isLabsShown ? /*#__PURE__*/_react.default.createElement(LabsFlyout, {
    solutions: ['dashboard'],
    onClose: () => setIsLabsShown(false)
  }) : null, viewMode === 'edit' ? /*#__PURE__*/_react.default.createElement(_dashboard_editing_toolbar.DashboardEditingToolbar, {
    isDisabled: !!focusedPanelId
  }) : null, showBorderBottom && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }));
}