"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmDiscardUnsavedChanges = exports.confirmCreateWithUnsaved = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../services/kibana_services");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const confirmDiscardUnsavedChanges = (discardCallback, viewMode = _public.ViewMode.EDIT // we want to show the danger modal on the listing page
) => {
  _kibana_services.coreServices.overlays.openConfirm(_dashboard_listing_strings.resetConfirmStrings.getResetSubtitle(viewMode), {
    confirmButtonText: _dashboard_listing_strings.resetConfirmStrings.getResetConfirmButtonText(),
    buttonColor: viewMode === _public.ViewMode.EDIT ? 'danger' : 'primary',
    maxWidth: 500,
    defaultFocusedButton: _eui.EUI_MODAL_CANCEL_BUTTON,
    title: _dashboard_listing_strings.resetConfirmStrings.getResetTitle()
  }).then(isConfirmed => {
    if (isConfirmed) {
      discardCallback();
    }
  });
};
exports.confirmDiscardUnsavedChanges = confirmDiscardUnsavedChanges;
const confirmCreateWithUnsaved = (startBlankCallback, contineCallback) => {
  const titleId = 'confirmDiscardOrKeepTitle';
  const descriptionId = 'confirmDiscardOrKeepDescription';
  const session = _kibana_services.coreServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true,
    initialFocus: '.dashboardCreateConfirmContinueButton'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => session.close()
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-modal": "true",
    "aria-labelledby": titleId,
    "aria-describedby": descriptionId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": "dashboardCreateConfirm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    component: "h2"
  }, _dashboard_listing_strings.createConfirmStrings.getCreateTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    id: descriptionId
  }, _dashboard_listing_strings.createConfirmStrings.getCreateSubtitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "dashboardCreateConfirmCancel",
    onClick: () => session.close()
  }, _dashboard_listing_strings.createConfirmStrings.getCancelButtonText()), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    "data-test-subj": "dashboardCreateConfirmStartOver",
    onClick: () => {
      startBlankCallback();
      session.close();
    }
  }, _dashboard_listing_strings.createConfirmStrings.getStartOverButtonText()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "dashboardCreateConfirmContinue",
    className: "dashboardCreateConfirmContinueButton",
    onClick: () => {
      contineCallback();
      session.close();
    }
  }, _dashboard_listing_strings.createConfirmStrings.getContinueButtonText()))))), {
    analytics: _kibana_services.coreServices.analytics,
    i18n: _kibana_services.coreServices.i18n,
    theme: _kibana_services.coreServices.theme
  }), {
    'data-test-subj': 'dashboardCreateConfirmModal'
  });
};
exports.confirmCreateWithUnsaved = confirmCreateWithUnsaved;