"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardContainerReducers = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardContainerReducers = exports.dashboardContainerReducers = {
  // ------------------------------------------------------------------------------
  // Content Reducers
  // ------------------------------------------------------------------------------
  setPanels: (state, action) => {
    state.explicitInput.panels = action.payload;
  },
  // ------------------------------------------------------------------------------
  // Meta info Reducers
  // ------------------------------------------------------------------------------
  setStateFromSaveModal: (state, action) => {
    state.explicitInput.tags = action.payload.tags;
    state.explicitInput.title = action.payload.title;
    state.explicitInput.description = action.payload.description;
    state.explicitInput.timeRestore = action.payload.timeRestore;
    if (action.payload.refreshInterval) {
      state.explicitInput.refreshInterval = action.payload.refreshInterval;
    }
    if (action.payload.timeRange) {
      state.explicitInput.timeRange = action.payload.timeRange;
    }
  },
  setStateFromSettingsFlyout: (state, action) => {
    state.explicitInput.tags = action.payload.tags;
    state.explicitInput.title = action.payload.title;
    state.explicitInput.description = action.payload.description;
    state.explicitInput.timeRestore = action.payload.timeRestore;
    state.explicitInput.useMargins = action.payload.useMargins;
    state.explicitInput.syncColors = action.payload.syncColors;
    state.explicitInput.syncCursor = action.payload.syncCursor;
    state.explicitInput.syncTooltips = action.payload.syncTooltips;
    state.explicitInput.hidePanelTitles = action.payload.hidePanelTitles;
  },
  setDescription: (state, action) => {
    state.explicitInput.description = action.payload;
  },
  setViewMode: (state, action) => {
    state.explicitInput.viewMode = action.payload;
  },
  setTags: (state, action) => {
    state.explicitInput.tags = action.payload;
  },
  setTitle: (state, action) => {
    state.explicitInput.title = action.payload;
  },
  /**
   * Resets the dashboard to the last saved input, excluding:
   * 1) The time range, unless `timeRestore` is `true` - if we include the time range on reset even when
   *    `timeRestore` is `false`, this causes unecessary data fetches for the control group.
   * 2) The view mode, since resetting should never impact this - sometimes the Dashboard saved objects
   *    have this saved in and we don't want resetting to cause unexpected view mode changes.
   */
  resetToLastSavedInput: (state, action) => {
    state.explicitInput = {
      ...action.payload,
      ...(!state.explicitInput.timeRestore && {
        timeRange: state.explicitInput.timeRange
      }),
      viewMode: state.explicitInput.viewMode
    };
  },
  // ------------------------------------------------------------------------------
  // Filtering Reducers
  // ------------------------------------------------------------------------------
  setFiltersAndQuery: (state, action) => {
    state.explicitInput.filters = action.payload.filters;
    state.explicitInput.query = action.payload.query;
  },
  setLastReloadRequestTimeToNow: state => {
    state.explicitInput.lastReloadRequestTime = new Date().getTime();
  },
  setFilters: (state, action) => {
    state.explicitInput.filters = action.payload;
  },
  setQuery: (state, action) => {
    state.explicitInput.query = action.payload;
  },
  setTimeRestore: (state, action) => {
    state.explicitInput.timeRestore = action.payload;
  },
  setTimeRange: (state, action) => {
    state.explicitInput.timeRange = action.payload;
  },
  setRefreshInterval: (state, action) => {
    state.explicitInput.refreshInterval = action.payload;
  },
  setTimeslice: (state, action) => {
    state.explicitInput.timeslice = action.payload;
  }
};