"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDashboardPanelPlacementSetting = exports.getDashboardPanelPlacementSetting = void 0;
var _dashboard_container_strings = require("../_dashboard_container_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = new Map();
const registerDashboardPanelPlacementSetting = (embeddableType, getPanelPlacementSettings) => {
  if (registry.has(embeddableType)) {
    throw new Error(_dashboard_container_strings.panelPlacementStrings.getPanelPlacementSettingsExistsError(embeddableType));
  }
  registry.set(embeddableType, getPanelPlacementSettings);
};
exports.registerDashboardPanelPlacementSetting = registerDashboardPanelPlacementSetting;
const getDashboardPanelPlacementSetting = embeddableType => {
  return registry.get(embeddableType);
};
exports.getDashboardPanelPlacementSetting = getDashboardPanelPlacementSetting;