"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = DashboardRenderer;
require("../_dashboard_container.scss");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_container_factory = require("../embeddable/dashboard_container_factory");
var _dashboard_ = require("./dashboard_404");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardRenderer({
  savedObjectId,
  getCreationOptions,
  dashboardRedirect,
  showPlainSpinner,
  locator,
  onApiAvailable
}) {
  const dashboardRoot = (0, _react.useRef)(null);
  const dashboardViewport = (0, _react.useRef)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  const [dashboardContainer, setDashboardContainer] = (0, _react.useState)();
  const [fatalError, setFatalError] = (0, _react.useState)();
  const [dashboardMissing, setDashboardMissing] = (0, _react.useState)(false);
  const id = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  (0, _react.useEffect)(() => {
    /* In case the locator prop changes, we need to reassign the value in the container */
    if (dashboardContainer) dashboardContainer.locator = locator;
  }, [dashboardContainer, locator]);
  (0, _react.useEffect)(() => {
    /**
     * Here we attempt to build a dashboard or navigate to a new dashboard. Clear all error states
     * if they exist in case this dashboard loads correctly.
     */
    fatalError === null || fatalError === void 0 ? void 0 : fatalError.destroy();
    setDashboardMissing(false);
    setFatalError(undefined);
    if (dashboardContainer) {
      // When a dashboard already exists, don't rebuild it, just set a new id.
      dashboardContainer.navigateToDashboard(savedObjectId).catch(e => {
        dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.destroy();
        setDashboardContainer(undefined);
        setFatalError(new _public.ErrorEmbeddable(e, {
          id
        }));
        if (e instanceof _common.SavedObjectNotFound) {
          setDashboardMissing(true);
        }
      });
      return;
    }
    setLoading(true);
    let canceled = false;
    (async () => {
      const creationOptions = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());
      const dashboardFactory = new _dashboard_container_factory.DashboardContainerFactoryDefinition(_kibana_services.embeddableService);
      const container = await dashboardFactory.create({
        id
      },
      // Input from creationOptions is used instead.
      undefined, creationOptions, savedObjectId);
      setLoading(false);
      if (canceled || !container) {
        setDashboardContainer(undefined);
        container === null || container === void 0 ? void 0 : container.destroy();
        return;
      }
      if ((0, _public.isErrorEmbeddable)(container)) {
        setFatalError(container);
        if (container.error instanceof _common.SavedObjectNotFound) {
          setDashboardMissing(true);
        }
        return;
      }
      if (dashboardRoot.current) {
        container.render(dashboardRoot.current);
      }
      setDashboardContainer(container);
      onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(container);
    })();
    return () => {
      canceled = true;
    };
    // Disabling exhaustive deps because embeddable should only be created on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedObjectId]);
  (0, _useUnmount.default)(() => {
    fatalError === null || fatalError === void 0 ? void 0 : fatalError.destroy();
    dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.destroy();
  });
  const viewportClasses = (0, _classnames.default)('dashboardViewport', {
    'dashboardViewport--screenshotMode': _kibana_services.screenshotModeService.isScreenshotMode()
  }, {
    'dashboardViewport--loading': loading
  });
  const loadingSpinner = showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xxl"
  });
  const renderDashboardContents = () => {
    if (dashboardMissing) return /*#__PURE__*/_react.default.createElement(_dashboard_.Dashboard404Page, {
      dashboardRedirect: dashboardRedirect
    });
    if (fatalError) return fatalError.render();
    if (loading) return loadingSpinner;
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: dashboardRoot
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: dashboardViewport,
    className: viewportClasses
  }, (dashboardViewport === null || dashboardViewport === void 0 ? void 0 : dashboardViewport.current) && dashboardContainer && !(0, _public.isErrorEmbeddable)(dashboardContainer) && /*#__PURE__*/_react.default.createElement(ParentClassController, {
    viewportRef: dashboardViewport.current,
    dashboardApi: dashboardContainer
  }), renderDashboardContents());
}

/**
 * Maximizing a panel in Dashboard only works if the parent div has a certain class. This
 * small component listens to the Dashboard's expandedPanelId state and adds and removes
 * the class to whichever element renders the Dashboard.
 */
const ParentClassController = ({
  dashboardApi,
  viewportRef
}) => {
  const maximizedPanelId = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.expandedPanelId);
  (0, _react.useLayoutEffect)(() => {
    const parentDiv = viewportRef.parentElement;
    if (!parentDiv) return;
    if (maximizedPanelId) {
      parentDiv.classList.add('dshDashboardViewportWrapper');
    } else {
      parentDiv.classList.remove('dshDashboardViewportWrapper');
    }
  }, [maximizedPanelId, viewportRef.parentElement]);
  return null;
};