"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _serialized_state = require("@kbn/presentation-containers/interfaces/serialized_state");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _dashboard_container_references = require("../../../common/dashboard_container/persistable_state/dashboard_container_references");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _dashboard_app_strings = require("../../dashboard_app/_dashboard_app_strings");
var _dashboard_constants = require("../../dashboard_constants");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../../services/dashboard_content_management_service");
var _kibana_services = require("../../services/kibana_services");
var _get_dashboard_capabilities = require("../../utils/get_dashboard_capabilities");
var _dashboard_viewport = require("../component/viewport/dashboard_viewport");
var _panel_placement = require("../panel_placement");
var _panel_placement_registry = require("../panel_placement/panel_placement_registry");
var _place_new_panel_strategies = require("../panel_placement/place_new_panel_strategies");
var _dashboard_container_reducers = require("../state/dashboard_container_reducers");
var _dashboard_diffing_integration = require("../state/diffing/dashboard_diffing_integration");
var _api = require("./api");
var _duplicate_dashboard_panel = require("./api/duplicate_dashboard_panel");
var _dashboard_control_group_integration = require("./create/controls/dashboard_control_group_integration");
var _create_dashboard = require("./create/create_dashboard");
var _dashboard_container_factory = require("./dashboard_container_factory");
var _get_dashboard_api = require("../../dashboard_api/get_dashboard_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DashboardContainer extends _public.Container {
  trackContentfulRender() {
    if (!this.hadContentfulRender) {
      _kibana_services.coreServices.analytics.reportEvent('dashboard_loaded_with_data', {});
    }
    this.hadContentfulRender = true;
  }
  constructor(initialInput, reduxToolsPackage, initialSessionId, dashboardCreationStartTime, parent, creationOptions, initialComponentState) {
    const controlGroupApi$ = new _rxjs.BehaviorSubject(undefined);
    async function untilContainerInitialized() {
      return new Promise(resolve => {
        controlGroupApi$.pipe((0, _rxjs.skipWhile)(controlGroupApi => !controlGroupApi), (0, _rxjs.switchMap)(async controlGroupApi => {
          // Bug in main where panels are loaded before control filters are ready
          // Want to migrate to react embeddable controls with same behavior
          // TODO - do not load panels until control filters are ready
          /*
            await controlGroupApi?.untilInitialized();
          */
        }), (0, _rxjs.first)()).subscribe(() => {
          resolve();
        });
      });
    }
    super({
      ...initialInput
    }, {
      embeddableLoaded: {}
    }, _kibana_services.embeddableService.getEmbeddableFactory, parent, {
      untilContainerInitialized
    });
    (0, _defineProperty2.default)(this, "type", _.DASHBOARD_CONTAINER_TYPE);
    // state management
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "anyReducerRun", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "setAnimatePanelTransforms", void 0);
    (0, _defineProperty2.default)(this, "setManaged", void 0);
    (0, _defineProperty2.default)(this, "setHasUnsavedChanges", void 0);
    (0, _defineProperty2.default)(this, "openOverlay", void 0);
    (0, _defineProperty2.default)(this, "clearOverlays", void 0);
    (0, _defineProperty2.default)(this, "highlightPanel", void 0);
    (0, _defineProperty2.default)(this, "setScrollToPanelId", void 0);
    (0, _defineProperty2.default)(this, "setFullScreenMode", void 0);
    (0, _defineProperty2.default)(this, "setExpandedPanelId", void 0);
    (0, _defineProperty2.default)(this, "setHighlightPanelId", void 0);
    (0, _defineProperty2.default)(this, "setLastSavedInput", void 0);
    (0, _defineProperty2.default)(this, "lastSavedInput$", void 0);
    (0, _defineProperty2.default)(this, "setSavedObjectId", void 0);
    (0, _defineProperty2.default)(this, "expandPanel", void 0);
    (0, _defineProperty2.default)(this, "scrollToPanel", void 0);
    (0, _defineProperty2.default)(this, "scrollToTop", void 0);
    (0, _defineProperty2.default)(this, "integrationSubscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "publishingSubscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "diffingSubscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "controlGroupApi$", void 0);
    (0, _defineProperty2.default)(this, "settings", void 0);
    (0, _defineProperty2.default)(this, "searchSessionId", void 0);
    (0, _defineProperty2.default)(this, "lastReloadRequestTime$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "searchSessionId$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "timeRestore$", void 0);
    (0, _defineProperty2.default)(this, "timeslice$", void 0);
    (0, _defineProperty2.default)(this, "unifiedSearchFilters$", void 0);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "executionContext", void 0);
    (0, _defineProperty2.default)(this, "domNode", void 0);
    // performance monitoring
    (0, _defineProperty2.default)(this, "lastLoadStartTime", void 0);
    (0, _defineProperty2.default)(this, "creationStartTime", void 0);
    (0, _defineProperty2.default)(this, "creationEndTime", void 0);
    (0, _defineProperty2.default)(this, "firstLoad", true);
    (0, _defineProperty2.default)(this, "hadContentfulRender", false);
    // setup
    (0, _defineProperty2.default)(this, "untilContainerInitialized", void 0);
    // cleanup
    (0, _defineProperty2.default)(this, "stopSyncingWithUnifiedSearch", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    // Services that are used in the Dashboard container code
    (0, _defineProperty2.default)(this, "creationOptions", void 0);
    (0, _defineProperty2.default)(this, "showWriteControls", void 0);
    (0, _defineProperty2.default)(this, "trackPanelAddMetric", void 0);
    // new embeddable framework
    (0, _defineProperty2.default)(this, "savedObjectReferences", []);
    (0, _defineProperty2.default)(this, "controlGroupInput", void 0);
    // ------------------------------------------------------------------------------------------------------
    // Dashboard API
    // ------------------------------------------------------------------------------------------------------
    (0, _defineProperty2.default)(this, "runInteractiveSave", _api.runInteractiveSave);
    (0, _defineProperty2.default)(this, "runQuickSave", _api.runQuickSave);
    (0, _defineProperty2.default)(this, "addFromLibrary", _api.addFromLibrary);
    (0, _defineProperty2.default)(this, "canRemovePanels", () => this.expandedPanelId.value === undefined);
    (0, _defineProperty2.default)(this, "getTypeDisplayName", () => _dashboard_container_factory.dashboardTypeDisplayName);
    (0, _defineProperty2.default)(this, "getTypeDisplayNameLowerCase", () => _dashboard_container_factory.dashboardTypeDisplayLowercase);
    (0, _defineProperty2.default)(this, "savedObjectId", void 0);
    (0, _defineProperty2.default)(this, "expandedPanelId", void 0);
    (0, _defineProperty2.default)(this, "focusedPanelId$", void 0);
    (0, _defineProperty2.default)(this, "managed$", void 0);
    (0, _defineProperty2.default)(this, "fullScreenMode$", void 0);
    (0, _defineProperty2.default)(this, "hasRunMigrations$", void 0);
    (0, _defineProperty2.default)(this, "hasUnsavedChanges$", void 0);
    (0, _defineProperty2.default)(this, "hasOverlays$", void 0);
    (0, _defineProperty2.default)(this, "useMargins$", void 0);
    (0, _defineProperty2.default)(this, "scrollToPanelId$", void 0);
    (0, _defineProperty2.default)(this, "highlightPanelId$", void 0);
    (0, _defineProperty2.default)(this, "animatePanelTransforms$", void 0);
    (0, _defineProperty2.default)(this, "panels$", void 0);
    (0, _defineProperty2.default)(this, "isEmbeddedExternally", void 0);
    (0, _defineProperty2.default)(this, "uuid$", void 0);
    (0, _defineProperty2.default)(this, "getDashboardPanelFromId", async panelId => {
      const panel = this.getInput().panels[panelId];
      if (_kibana_services.embeddableService.reactEmbeddableRegistryHasKey(panel.type)) {
        const child = this.children$.value[panelId];
        if (!child) throw new _public.PanelNotFoundError();
        const serialized = (0, _serialized_state.apiHasSerializableState)(child) ? await child.serializeState() : {
          rawState: {}
        };
        return {
          type: panel.type,
          explicitInput: {
            ...panel.explicitInput,
            ...serialized.rawState
          },
          gridData: panel.gridData,
          references: serialized.references
        };
      }
      return panel;
    });
    (0, _defineProperty2.default)(this, "addOrUpdateEmbeddable", _api.addOrUpdateEmbeddable);
    (0, _defineProperty2.default)(this, "navigateToDashboard", async (newSavedObjectId, newCreationOptions) => {
      var _this$stopSyncingWith, _loadDashboardReturn$;
      this.integrationSubscriptions.unsubscribe();
      this.integrationSubscriptions = new _rxjs.Subscription();
      (_this$stopSyncingWith = this.stopSyncingWithUnifiedSearch) === null || _this$stopSyncingWith === void 0 ? void 0 : _this$stopSyncingWith.call(this);
      if (newCreationOptions) {
        this.creationOptions = {
          ...this.creationOptions,
          ...newCreationOptions
        };
      }
      const loadDashboardReturn = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().loadDashboardState({
        id: newSavedObjectId
      });
      const dashboardContainerReady$ = new _rxjs.Subject();
      const untilDashboardReady = () => new Promise(resolve => {
        const subscription = dashboardContainerReady$.subscribe(container => {
          subscription.unsubscribe();
          resolve(container);
        });
      });
      const initializeResult = await (0, _create_dashboard.initializeDashboard)({
        creationOptions: this.creationOptions,
        untilDashboardReady,
        loadDashboardReturn
      });
      if (!initializeResult) return;
      const {
        input: newInput,
        searchSessionId
      } = initializeResult;
      this.searchSessionId = searchSessionId;
      this.searchSessionId$.next(searchSessionId);
      this.setAnimatePanelTransforms(false); // prevents panels from animating on navigate.
      this.setManaged((_loadDashboardReturn$ = loadDashboardReturn === null || loadDashboardReturn === void 0 ? void 0 : loadDashboardReturn.managed) !== null && _loadDashboardReturn$ !== void 0 ? _loadDashboardReturn$ : false);
      this.setExpandedPanelId(undefined);
      this.setLastSavedInput((0, _lodash.omit)(loadDashboardReturn === null || loadDashboardReturn === void 0 ? void 0 : loadDashboardReturn.dashboardInput, 'controlGroupInput'));
      this.setSavedObjectId(newSavedObjectId);
      this.firstLoad = true;
      this.updateInput(newInput);
      dashboardContainerReady$.next(this);
    });
    /**
     * Use this to set the dataviews that are used in the dashboard when they change/update
     * @param newDataViews The new array of dataviews that will overwrite the old dataviews array
     */
    (0, _defineProperty2.default)(this, "setAllDataViews", newDataViews => {
      this.dataViews.next(newDataViews);
    });
    (0, _defineProperty2.default)(this, "getPanelsState", () => {
      return this.getState().explicitInput.panels;
    });
    (0, _defineProperty2.default)(this, "getSettings", () => {
      const state = this.getState();
      return {
        description: state.explicitInput.description,
        hidePanelTitles: state.explicitInput.hidePanelTitles,
        syncColors: state.explicitInput.syncColors,
        syncCursor: state.explicitInput.syncCursor,
        syncTooltips: state.explicitInput.syncTooltips,
        tags: state.explicitInput.tags,
        timeRestore: state.explicitInput.timeRestore,
        title: state.explicitInput.title,
        useMargins: state.explicitInput.useMargins
      };
    });
    (0, _defineProperty2.default)(this, "setSettings", settings => {
      this.dispatch.setStateFromSettingsFlyout(settings);
    });
    (0, _defineProperty2.default)(this, "setViewMode", viewMode => {
      // block the Dashboard from entering edit mode if this Dashboard is managed.
      if (this.managed$.value && (viewMode === null || viewMode === void 0 ? void 0 : viewMode.toLowerCase()) === _public.ViewMode.EDIT) {
        return;
      }
      this.dispatch.setViewMode(viewMode);
    });
    (0, _defineProperty2.default)(this, "setQuery", query => this.updateInput({
      query
    }));
    (0, _defineProperty2.default)(this, "setFilters", filters => this.updateInput({
      filters
    }));
    (0, _defineProperty2.default)(this, "setTags", tags => {
      this.updateInput({
        tags
      });
    });
    (0, _defineProperty2.default)(this, "getPanelCount", () => {
      return Object.keys(this.getInput().panels).length;
    });
    (0, _defineProperty2.default)(this, "setPanels", panels => {
      this.dispatch.setPanels(panels);
    });
    // ------------------------------------------------------------------------------------------------------
    // React Embeddable system
    // ------------------------------------------------------------------------------------------------------
    (0, _defineProperty2.default)(this, "registerChildApi", api => {
      this.children$.next({
        ...this.children$.value,
        [api.uuid]: api
      });
    });
    (0, _defineProperty2.default)(this, "saveNotification$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "getSerializedStateForChild", childId => {
      const rawState = this.getInput().panels[childId].explicitInput;
      const {
        id,
        ...serializedState
      } = rawState;
      if (!rawState || Object.keys(serializedState).length === 0) return;
      const references = (0, _dashboard_container_references.getReferencesForPanelId)(childId, this.savedObjectReferences);
      return {
        rawState,
        // references from old installations may not be prefixed with panel id
        // fall back to passing all references in these cases to preserve backwards compatability
        references: references.length > 0 ? references : this.savedObjectReferences
      };
    });
    (0, _defineProperty2.default)(this, "getSerializedStateForControlGroup", () => {
      return {
        rawState: this.controlGroupInput ? this.controlGroupInput : {
          controlStyle: 'oneLine',
          chainingSystem: 'HIERARCHICAL',
          showApplySelections: false,
          panelsJSON: '{}',
          ignoreParentSettingsJSON: '{"ignoreFilters":false,"ignoreQuery":false,"ignoreTimerange":false,"ignoreValidations":false}'
        },
        references: (0, _dashboard_container_references.getReferencesForControls)(this.savedObjectReferences)
      };
    });
    (0, _defineProperty2.default)(this, "restoredRuntimeState", undefined);
    (0, _defineProperty2.default)(this, "setRuntimeStateForChild", (childId, state) => {
      var _this$restoredRuntime;
      const runtimeState = (_this$restoredRuntime = this.restoredRuntimeState) !== null && _this$restoredRuntime !== void 0 ? _this$restoredRuntime : {};
      runtimeState[childId] = state;
      this.restoredRuntimeState = runtimeState;
    });
    (0, _defineProperty2.default)(this, "getRuntimeStateForChild", childId => {
      var _this$restoredRuntime2;
      return (_this$restoredRuntime2 = this.restoredRuntimeState) === null || _this$restoredRuntime2 === void 0 ? void 0 : _this$restoredRuntime2[childId];
    });
    (0, _defineProperty2.default)(this, "getRuntimeStateForControlGroup", () => {
      return this.getRuntimeStateForChild(_dashboard_backup_service.PANELS_CONTROL_GROUP_KEY);
    });
    (0, _defineProperty2.default)(this, "startAuditingReactEmbeddableChildren", () => {
      const auditChildren = () => {
        const currentChildren = this.children$.value;
        let panelsChanged = false;
        for (const panelId of Object.keys(currentChildren)) {
          if (!this.getInput().panels[panelId]) {
            delete currentChildren[panelId];
            panelsChanged = true;
          }
        }
        if (panelsChanged) this.children$.next(currentChildren);
      };

      // audit children when panels change
      this.publishingSubscription.add(this.getInput$().pipe((0, _rxjs.map)(() => Object.keys(this.getInput().panels)), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)).subscribe(() => auditChildren()));
      auditChildren();
    });
    (0, _defineProperty2.default)(this, "resetAllReactEmbeddables", () => {
      this.restoredRuntimeState = undefined;
      let resetChangedPanelCount = false;
      const currentChildren = this.children$.value;
      for (const panelId of Object.keys(currentChildren)) {
        if (this.getInput().panels[panelId]) {
          const child = currentChildren[panelId];
          if ((0, _presentationPublishing.apiPublishesUnsavedChanges)(child)) {
            const success = child.resetUnsavedChanges();
            if (!success) {
              _kibana_services.coreServices.notifications.toasts.addWarning(_i18n.i18n.translate('dashboard.reset.panelError', {
                defaultMessage: 'Unable to reset panel changes'
              }));
            }
          }
        } else {
          // if reset resulted in panel removal, we need to update the list of children
          delete currentChildren[panelId];
          resetChangedPanelCount = true;
        }
      }
      if (resetChangedPanelCount) this.children$.next(currentChildren);
    });
    ({
      showWriteControls: this.showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)());
    this.controlGroupApi$ = controlGroupApi$;
    this.untilContainerInitialized = untilContainerInitialized;
    this.trackPanelAddMetric = _kibana_services.usageCollectionService === null || _kibana_services.usageCollectionService === void 0 ? void 0 : _kibana_services.usageCollectionService.reportUiCounter.bind(_kibana_services.usageCollectionService, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
    this.creationOptions = creationOptions;
    this.searchSessionId = initialSessionId;
    this.searchSessionId$.next(initialSessionId);
    this.creationStartTime = dashboardCreationStartTime;

    // start diffing dashboard state
    const diffingMiddleware = _dashboard_diffing_integration.getDiffingMiddleware.bind(this)();

    // build redux embeddable tools
    const reduxTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _dashboard_container_reducers.dashboardContainerReducers,
      additionalMiddleware: [diffingMiddleware]
    });
    this.onStateChange = reduxTools.onStateChange;
    this.cleanupStateTools = reduxTools.cleanup;
    this.getState = reduxTools.getState;
    this.dispatch = reduxTools.dispatch;
    this.select = reduxTools.select;
    this.uuid$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'id');
    const dashboardApi = (0, _get_dashboard_api.getDashboardApi)(initialComponentState ? initialComponentState : {
      anyMigrationRun: false,
      isEmbeddedExternally: false,
      lastSavedInput: initialInput,
      lastSavedId: undefined,
      fullScreenMode: false,
      managed: false
    }, id => this.untilEmbeddableLoaded(id));
    this.animatePanelTransforms$ = dashboardApi.animatePanelTransforms$;
    this.fullScreenMode$ = dashboardApi.fullScreenMode$;
    this.hasUnsavedChanges$ = dashboardApi.hasUnsavedChanges$;
    this.isEmbeddedExternally = dashboardApi.isEmbeddedExternally;
    this.managed$ = dashboardApi.managed$;
    this.setAnimatePanelTransforms = dashboardApi.setAnimatePanelTransforms;
    this.setFullScreenMode = dashboardApi.setFullScreenMode;
    this.setHasUnsavedChanges = dashboardApi.setHasUnsavedChanges;
    this.setManaged = dashboardApi.setManaged;
    this.expandedPanelId = dashboardApi.expandedPanelId;
    this.focusedPanelId$ = dashboardApi.focusedPanelId$;
    this.highlightPanelId$ = dashboardApi.highlightPanelId$;
    this.highlightPanel = dashboardApi.highlightPanel;
    this.setExpandedPanelId = dashboardApi.setExpandedPanelId;
    this.setHighlightPanelId = dashboardApi.setHighlightPanelId;
    this.scrollToPanelId$ = dashboardApi.scrollToPanelId$;
    this.setScrollToPanelId = dashboardApi.setScrollToPanelId;
    this.clearOverlays = dashboardApi.clearOverlays;
    this.hasOverlays$ = dashboardApi.hasOverlays$;
    this.openOverlay = dashboardApi.openOverlay;
    this.hasRunMigrations$ = dashboardApi.hasRunMigrations$;
    this.setLastSavedInput = dashboardApi.setLastSavedInput;
    this.lastSavedInput$ = dashboardApi.lastSavedInput$;
    this.savedObjectId = dashboardApi.savedObjectId;
    this.setSavedObjectId = dashboardApi.setSavedObjectId;
    this.expandPanel = dashboardApi.expandPanel;
    this.scrollToPanel = dashboardApi.scrollToPanel;
    this.scrollToTop = dashboardApi.scrollToTop;
    this.useMargins$ = new _rxjs.BehaviorSubject(this.getState().explicitInput.useMargins);
    this.panels$ = new _rxjs.BehaviorSubject(this.getState().explicitInput.panels);
    this.publishingSubscription.add(this.onStateChange(() => {
      const state = this.getState();
      if (this.useMargins$.value !== state.explicitInput.useMargins) {
        this.useMargins$.next(state.explicitInput.useMargins);
      }
      if (this.panels$.value !== state.explicitInput.panels) {
        this.panels$.next(state.explicitInput.panels);
      }
    }));
    this.startAuditingReactEmbeddableChildren();
    this.settings = {
      syncColors$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncColors'),
      syncCursor$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncCursor'),
      syncTooltips$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncTooltips')
    };
    this.timeRestore$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'timeRestore');
    this.timeslice$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'timeslice');
    this.lastReloadRequestTime$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'lastReloadRequestTime');
    (0, _dashboard_control_group_integration.startSyncingDashboardControlGroup)(this);
    this.executionContext = initialInput.executionContext;
    this.dataLoading = new _rxjs.BehaviorSubject(false);
    this.publishingSubscription.add((0, _presentationContainers.combineCompatibleChildrenApis)(this, 'dataLoading', _presentationPublishing.apiPublishesDataLoading, undefined,
    // flatten method
    values => {
      return values.some(isLoading => isLoading);
    }).subscribe(isAtLeastOneChildLoading => {
      this.dataLoading.next(isAtLeastOneChildLoading);
    }));
    this.dataViews = new _rxjs.BehaviorSubject([]);
    const query$ = new _rxjs.BehaviorSubject(this.getInput().query);
    this.query$ = query$;
    this.publishingSubscription.add(this.getInput$().subscribe(input => {
      var _query$$getValue;
      if (!(0, _fastDeepEqual.default)((_query$$getValue = query$.getValue()) !== null && _query$$getValue !== void 0 ? _query$$getValue : [], input.query)) {
        query$.next(input.query);
      }
    }));
  }
  setControlGroupApi(controlGroupApi) {
    this.controlGroupApi$.next(controlGroupApi);
  }
  getAppContext() {
    var _this$creationOptions, _this$creationOptions2, _embeddableAppContext;
    const embeddableAppContext = (_this$creationOptions = this.creationOptions) === null || _this$creationOptions === void 0 ? void 0 : (_this$creationOptions2 = _this$creationOptions.getEmbeddableAppContext) === null || _this$creationOptions2 === void 0 ? void 0 : _this$creationOptions2.call(_this$creationOptions, this.savedObjectId.value);
    return {
      ...embeddableAppContext,
      currentAppId: (_embeddableAppContext = embeddableAppContext === null || embeddableAppContext === void 0 ? void 0 : embeddableAppContext.currentAppId) !== null && _embeddableAppContext !== void 0 ? _embeddableAppContext : _dashboard_constants.DASHBOARD_APP_ID
    };
  }
  createNewPanelState(factory, partial = {}, attributes) {
    const {
      newPanel
    } = super.createNewPanelState(factory, partial, attributes);
    return (0, _panel_placement.placePanel)(factory, newPanel, this.input.panels, attributes);
  }
  render(dom) {
    if (this.domNode) {
      _reactDom.default.unmountComponentAtNode(this.domNode);
    }
    this.domNode = dom;
    this.domNode.className = 'dashboardContainer';
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
      analytics: _kibana_services.coreServices.analytics,
      i18n: _kibana_services.coreServices.i18n,
      theme: _kibana_services.coreServices.theme
    }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: {
        chrome: _kibana_services.coreServices.chrome,
        customBranding: _kibana_services.coreServices.customBranding
      }
    }, /*#__PURE__*/_react.default.createElement(_use_dashboard_api.DashboardContext.Provider, {
      value: this
    }, /*#__PURE__*/_react.default.createElement(_dashboard_viewport.DashboardViewport, null)))), dom);
  }
  updateInput(changes) {
    var _changes$viewMode, _ViewMode$EDIT;
    // block the Dashboard from entering edit mode if this Dashboard is managed.
    if ((this.managed$.value || !this.showWriteControls) && ((_changes$viewMode = changes.viewMode) === null || _changes$viewMode === void 0 ? void 0 : _changes$viewMode.toLowerCase()) === ((_ViewMode$EDIT = _public.ViewMode.EDIT) === null || _ViewMode$EDIT === void 0 ? void 0 : _ViewMode$EDIT.toLowerCase())) {
      const {
        viewMode,
        ...rest
      } = changes;
      super.updateInput(rest);
      return;
    }
    super.updateInput(changes);
  }
  getInheritedInput(id) {
    var _this$controlGroupApi, _panels$id, _panels$id$explicitIn;
    const {
      query,
      filters,
      viewMode,
      timeRange,
      timeslice,
      syncColors,
      syncTooltips,
      syncCursor,
      hidePanelTitles,
      refreshInterval,
      executionContext,
      panels
    } = this.input;
    const combinedFilters = (0, _dashboard_control_group_integration.combineDashboardFiltersWithControlGroupFilters)(filters, (_this$controlGroupApi = this.controlGroupApi$) === null || _this$controlGroupApi === void 0 ? void 0 : _this$controlGroupApi.value);
    const hasCustomTimeRange = Boolean((_panels$id = panels[id]) === null || _panels$id === void 0 ? void 0 : (_panels$id$explicitIn = _panels$id.explicitInput) === null || _panels$id$explicitIn === void 0 ? void 0 : _panels$id$explicitIn.timeRange);
    return {
      searchSessionId: this.searchSessionId,
      refreshConfig: refreshInterval,
      filters: combinedFilters,
      hidePanelTitles,
      executionContext,
      syncTooltips,
      syncColors,
      syncCursor,
      viewMode,
      query,
      id,
      // do not pass any time information from dashboard to panel when panel has custom time range
      // to avoid confusing panel which timeRange should be used
      timeRange: hasCustomTimeRange ? undefined : timeRange,
      timeslice: hasCustomTimeRange ? undefined : timeslice
    };
  }

  // ------------------------------------------------------------------------------------------------------
  // Cleanup
  // ------------------------------------------------------------------------------------------------------
  destroy() {
    var _this$stopSyncingWith2;
    super.destroy();
    this.cleanupStateTools();
    this.diffingSubscription.unsubscribe();
    this.publishingSubscription.unsubscribe();
    this.integrationSubscriptions.unsubscribe();
    (_this$stopSyncingWith2 = this.stopSyncingWithUnifiedSearch) === null || _this$stopSyncingWith2 === void 0 ? void 0 : _this$stopSyncingWith2.call(this);
    if (this.domNode) _reactDom.default.unmountComponentAtNode(this.domNode);
  }
  duplicatePanel(id) {
    _duplicate_dashboard_panel.duplicateDashboardPanel.bind(this)(id);
  }
  async replacePanel(idToRemove, {
    panelType,
    initialState
  }) {
    const newId = await this.replaceEmbeddable(idToRemove, initialState, panelType, true);
    if (this.expandedPanelId.value !== undefined) {
      this.setExpandedPanelId(newId);
    }
    this.setHighlightPanelId(newId);
    return newId;
  }
  async addNewPanel(panelPackage, displaySuccessMessage) {
    const onSuccess = (id, title) => {
      if (!displaySuccessMessage) return;
      _kibana_services.coreServices.notifications.toasts.addSuccess({
        title: (0, _dashboard_app_strings.getPanelAddedSuccessString)(title),
        'data-test-subj': 'addEmbeddableToDashboardSuccess'
      });
      this.setScrollToPanelId(id);
      this.setHighlightPanelId(id);
    };
    if (this.trackPanelAddMetric) {
      this.trackPanelAddMetric(_analytics.METRIC_TYPE.CLICK, panelPackage.panelType);
    }
    if (_kibana_services.embeddableService.reactEmbeddableRegistryHasKey(panelPackage.panelType)) {
      const newId = (0, _uuid.v4)();
      const getCustomPlacementSettingFunc = (0, _panel_placement_registry.getDashboardPanelPlacementSetting)(panelPackage.panelType);
      const customPlacementSettings = getCustomPlacementSettingFunc ? await getCustomPlacementSettingFunc(panelPackage.initialState) : {};
      const placementSettings = {
        width: _dashboard_constants.DEFAULT_PANEL_WIDTH,
        height: _dashboard_constants.DEFAULT_PANEL_HEIGHT,
        strategy: _dashboard_constants.PanelPlacementStrategy.findTopLeftMostOpenSpace,
        ...customPlacementSettings
      };
      const {
        width,
        height,
        strategy
      } = placementSettings;
      const {
        newPanelPlacement,
        otherPanels
      } = (0, _place_new_panel_strategies.runPanelPlacementStrategy)(strategy, {
        currentPanels: this.getInput().panels,
        height,
        width
      });
      const newPanel = {
        type: panelPackage.panelType,
        gridData: {
          ...newPanelPlacement,
          i: newId
        },
        explicitInput: {
          id: newId
        }
      };
      if (panelPackage.initialState) {
        this.setRuntimeStateForChild(newId, panelPackage.initialState);
      }
      this.updateInput({
        panels: {
          ...otherPanels,
          [newId]: newPanel
        }
      });
      onSuccess(newId, newPanel.explicitInput.title);
      return await this.untilReactEmbeddableLoaded(newId);
    }
    const embeddableFactory = _kibana_services.embeddableService.getEmbeddableFactory(panelPackage.panelType);
    if (!embeddableFactory) {
      throw new _public.EmbeddableFactoryNotFoundError(panelPackage.panelType);
    }
    const initialInput = panelPackage.initialState;
    let explicitInput;
    let attributes;
    try {
      if (initialInput) {
        explicitInput = initialInput;
      } else {
        const explicitInputReturn = await embeddableFactory.getExplicitInput(undefined, this);
        if ((0, _public.isExplicitInputWithAttributes)(explicitInputReturn)) {
          explicitInput = explicitInputReturn.newInput;
          attributes = explicitInputReturn.attributes;
        } else {
          explicitInput = explicitInputReturn;
        }
      }
    } catch (e) {
      // error likely means user canceled embeddable creation
      return;
    }
    const newEmbeddable = await this.addNewEmbeddable(embeddableFactory.type, explicitInput, attributes);
    if (newEmbeddable) {
      onSuccess(newEmbeddable.id, newEmbeddable.getTitle());
    }
    return newEmbeddable;
  }
  forceRefresh(refreshControlGroup = true) {
    this.dispatch.setLastReloadRequestTimeToNow({});
    if (refreshControlGroup) {
      // only reload all panels if this refresh does not come from the control group.
      this.reload$.next();
    }
  }
  async asyncResetToLastSavedState() {
    var _this$creationOptions3;
    this.dispatch.resetToLastSavedInput(this.lastSavedInput$.value);
    const {
      explicitInput: {
        timeRange,
        refreshInterval
      }
    } = this.getState();
    const {
      timeRestore: lastSavedTimeRestore
    } = this.lastSavedInput$.value;
    if (this.controlGroupApi$.value) {
      await this.controlGroupApi$.value.asyncResetUnsavedChanges();
    }

    // if we are using the unified search integration, we need to force reset the time picker.
    if ((_this$creationOptions3 = this.creationOptions) !== null && _this$creationOptions3 !== void 0 && _this$creationOptions3.useUnifiedSearchIntegration && lastSavedTimeRestore) {
      const timeFilterService = _kibana_services.dataService.query.timefilter.timefilter;
      if (timeRange) timeFilterService.setTime(timeRange);
      if (refreshInterval) timeFilterService.setRefreshInterval(refreshInterval);
    }
    this.resetAllReactEmbeddables();
  }
  async getPanelTitles() {
    const titles = [];
    for (const [id, panel] of Object.entries(this.getInput().panels)) {
      const title = await (async () => {
        if (_kibana_services.embeddableService.reactEmbeddableRegistryHasKey(panel.type)) {
          const child = this.children$.value[id];
          return (0, _presentationPublishing.apiPublishesPanelTitle)(child) ? (0, _presentationPublishing.getPanelTitle)(child) : '';
        }
        await this.untilEmbeddableLoaded(id);
        const child = this.getChild(id);
        if (!child) return undefined;
        return child.getTitle();
      })();
      if (title) titles.push(title);
    }
    return titles;
  }
  removePanel(id) {
    var _this$getInput$panels;
    const type = (_this$getInput$panels = this.getInput().panels[id]) === null || _this$getInput$panels === void 0 ? void 0 : _this$getInput$panels.type;
    this.removeEmbeddable(id);
    if (_kibana_services.embeddableService.reactEmbeddableRegistryHasKey(type)) {
      const {
        [id]: childToRemove,
        ...otherChildren
      } = this.children$.value;
      this.children$.next(otherChildren);
    }
  }
}
exports.DashboardContainer = DashboardContainer;