"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSyncingDashboardDataViews = startSyncingDashboardDataViews;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function startSyncingDashboardDataViews() {
  const controlGroupDataViewsPipe = this.controlGroupApi$.pipe((0, _rxjs.switchMap)(controlGroupApi => {
    return controlGroupApi ? controlGroupApi.dataViews : (0, _rxjs.of)([]);
  }));
  const childDataViewsPipe = (0, _presentationContainers.combineCompatibleChildrenApis)(this, 'dataViews', _presentationPublishing.apiPublishesDataViews, []);
  return (0, _rxjs.combineLatest)([controlGroupDataViewsPipe, childDataViewsPipe]).pipe((0, _rxjs.switchMap)(([controlGroupDataViews, childDataViews]) => {
    const allDataViews = [...(controlGroupDataViews ? controlGroupDataViews : []), ...childDataViews];
    if (allDataViews.length === 0) {
      return (async () => {
        const defaultDataViewId = await _kibana_services.dataService.dataViews.getDefaultId();
        return [await _kibana_services.dataService.dataViews.get(defaultDataViewId)];
      })();
    }
    return (0, _rxjs.of)((0, _lodash.uniqBy)(allDataViews, 'id'));
  })).subscribe(newDataViews => {
    this.setAllDataViews(newDataViews);
  });
}