"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineDashboardFiltersWithControlGroupFilters = void 0;
exports.startSyncingDashboardControlGroup = startSyncingDashboardControlGroup;
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function startSyncingDashboardControlGroup(dashboard) {
  const controlGroupFilters$ = dashboard.controlGroupApi$.pipe((0, _rxjs.switchMap)(controlGroupApi => controlGroupApi ? controlGroupApi.filters$ : (0, _rxjs.of)(undefined)));
  const controlGroupTimeslice$ = dashboard.controlGroupApi$.pipe((0, _rxjs.switchMap)(controlGroupApi => controlGroupApi ? controlGroupApi.timeslice$ : (0, _rxjs.of)(undefined)));

  // --------------------------------------------------------------------------------------
  // dashboard.unifiedSearchFilters$
  // --------------------------------------------------------------------------------------
  const unifiedSearchFilters$ = new _rxjs.BehaviorSubject(dashboard.getInput().filters);
  dashboard.unifiedSearchFilters$ = unifiedSearchFilters$;
  dashboard.publishingSubscription.add(dashboard.getInput$().pipe((0, _rxjs.startWith)(dashboard.getInput()), (0, _rxjs.map)(input => input.filters), (0, _rxjs.distinctUntilChanged)((previous, current) => {
    return (0, _esQuery.compareFilters)(previous !== null && previous !== void 0 ? previous : [], current !== null && current !== void 0 ? current : [], _esQuery.COMPARE_ALL_OPTIONS);
  })).subscribe(unifiedSearchFilters => {
    unifiedSearchFilters$.next(unifiedSearchFilters);
  }));

  // --------------------------------------------------------------------------------------
  // Set dashboard.filters$ to include unified search filters and control group filters
  // --------------------------------------------------------------------------------------
  function getCombinedFilters() {
    var _dashboard$getInput$f;
    return combineDashboardFiltersWithControlGroupFilters((_dashboard$getInput$f = dashboard.getInput().filters) !== null && _dashboard$getInput$f !== void 0 ? _dashboard$getInput$f : [], dashboard.controlGroupApi$.value);
  }
  const filters$ = new _rxjs.BehaviorSubject(getCombinedFilters());
  dashboard.filters$ = filters$;
  dashboard.publishingSubscription.add((0, _rxjs.combineLatest)([dashboard.unifiedSearchFilters$, controlGroupFilters$]).subscribe(() => {
    filters$.next(getCombinedFilters());
  }));

  // --------------------------------------------------------------------------------------
  // when control group outputs filters, force a refresh!
  // --------------------------------------------------------------------------------------
  dashboard.publishingSubscription.add(controlGroupFilters$.pipe((0, _rxjs.skip)(1) // skip first filter output because it will have been applied in initialize
  ).subscribe(() => dashboard.forceRefresh(false)) // we should not reload the control group when the control group output changes - otherwise, performance is severely impacted
  );

  // --------------------------------------------------------------------------------------
  // when control group outputs timeslice, dispatch timeslice
  // --------------------------------------------------------------------------------------
  dashboard.publishingSubscription.add(controlGroupTimeslice$.subscribe(timeslice => {
    dashboard.dispatch.setTimeslice(timeslice);
  }));
}
const combineDashboardFiltersWithControlGroupFilters = (dashboardFilters, controlGroupApi) => {
  var _controlGroupApi$filt;
  return [...dashboardFilters, ...((_controlGroupApi$filt = controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.filters$.value) !== null && _controlGroupApi$filt !== void 0 ? _controlGroupApi$filt : [])];
};
exports.combineDashboardFiltersWithControlGroupFilters = combineDashboardFiltersWithControlGroupFilters;