"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSettingsFlyout = openSettingsFlyout;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../../services/kibana_services");
var _settings_flyout = require("../../component/settings/settings_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function openSettingsFlyout(dashboardApi) {
  dashboardApi.openOverlay(_kibana_services.coreServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_use_dashboard_api.DashboardContext.Provider, {
    value: dashboardApi
  }, /*#__PURE__*/_react.default.createElement(_settings_flyout.DashboardSettings, {
    onClose: () => {
      dashboardApi.clearOverlays();
    }
  })), {
    analytics: _kibana_services.coreServices.analytics,
    i18n: _kibana_services.coreServices.i18n,
    theme: _kibana_services.coreServices.theme
  }), {
    size: 's',
    'data-test-subj': 'dashboardSettingsFlyout',
    onClose: flyout => {
      dashboardApi.clearOverlays();
      flyout.close();
    }
  }));
}