"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebouncedWidthObserver = exports.DashboardViewportComponent = exports.DashboardViewport = void 0;
var _lodash = require("lodash");
var _classnames = _interopRequireDefault(require("classnames"));
var _polyfilled = _interopRequireDefault(require("use-resize-observer/polyfilled"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _common = require("@kbn/controls-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _grid = require("../grid");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _dashboard_empty_screen = require("../empty_screen/dashboard_empty_screen");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDebouncedWidthObserver = (skipDebounce = false, wait = 100) => {
  const [width, setWidth] = (0, _react.useState)(0);
  const onWidthChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(setWidth, wait), [wait]);
  const {
    ref
  } = (0, _polyfilled.default)({
    onResize: dimensions => {
      if (dimensions.width) {
        if (width === 0 || skipDebounce) setWidth(dimensions.width);
        if (dimensions.width !== width) onWidthChange(dimensions.width);
      }
    }
  });
  return {
    ref,
    width
  };
};
exports.useDebouncedWidthObserver = useDebouncedWidthObserver;
const DashboardViewportComponent = () => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [hasControls, setHasControls] = (0, _react.useState)(false);
  const [controlGroupApi, dashboardTitle, description, expandedPanelId, focusedPanelId, panels, viewMode, useMargins, uuid] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.controlGroupApi$, dashboardApi.panelTitle, dashboardApi.panelDescription, dashboardApi.expandedPanelId, dashboardApi.focusedPanelId$, dashboardApi.panels$, dashboardApi.viewMode, dashboardApi.useMargins$, dashboardApi.uuid$);
  const panelCount = (0, _react.useMemo)(() => {
    return Object.keys(panels).length;
  }, [panels]);
  const {
    ref: resizeRef,
    width: viewportWidth
  } = useDebouncedWidthObserver(!!focusedPanelId);
  const classes = (0, _classnames.default)({
    dshDashboardViewport: true,
    'dshDashboardViewport--panelExpanded': Boolean(expandedPanelId)
  });
  (0, _react.useEffect)(() => {
    if (!controlGroupApi) {
      return;
    }
    const subscription = controlGroupApi.children$.subscribe(children => {
      setHasControls(Object.keys(children).length > 0);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroupApi]);

  // Bug in main where panels are loaded before control filters are ready
  // Want to migrate to react embeddable controls with same behavior
  // TODO - do not load panels until control filters are ready
  /*
  const [dashboardInitialized, setDashboardInitialized] = useState(false);
  useEffect(() => {
    let ignore = false;
    dashboard.untilContainerInitialized().then(() => {
      if (!ignore) {
        setDashboardInitialized(true);
      }
    });
    return () => {
      ignore = true;
    };
  }, [dashboard]);
  */

  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('dshDashboardViewportWrapper', {
      'dshDashboardViewportWrapper--defaultBg': !useMargins
    })
  }, viewMode !== _public.ViewMode.PRINT ? /*#__PURE__*/_react.default.createElement("div", {
    className: hasControls ? 'dshDashboardViewport-controls' : ''
  }, /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
    key: uuid,
    hidePanelChrome: true,
    panelProps: {
      hideLoader: true
    },
    type: _common.CONTROL_GROUP_TYPE,
    maybeId: 'control_group',
    getParentApi: () => {
      return {
        ...dashboardApi,
        getSerializedStateForChild: dashboardApi.getSerializedStateForControlGroup,
        getRuntimeStateForChild: dashboardApi.getRuntimeStateForControlGroup
      };
    },
    onApiAvailable: api => dashboardApi.setControlGroupApi(api)
  })) : null, panelCount === 0 && /*#__PURE__*/_react.default.createElement(_dashboard_empty_screen.DashboardEmptyScreen, null), /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    className: classes,
    "data-shared-items-container": true,
    "data-title": dashboardTitle,
    "data-description": description,
    "data-shared-items-count": panelCount
  }, viewportWidth !== 0 && /*#__PURE__*/_react.default.createElement(_grid.DashboardGrid, {
    viewportWidth: viewportWidth
  })));
};

// This fullscreen button HOC separates fullscreen button and dashboard content to reduce rerenders
// because ExitFullScreenButton sets isFullscreenMode to false on unmount while rerendering.
// This specifically fixed maximizing/minimizing panels without exiting fullscreen mode.
exports.DashboardViewportComponent = DashboardViewportComponent;
const WithFullScreenButton = ({
  children
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const isFullScreenMode = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.fullScreenMode$);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, isFullScreenMode && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButton, {
    onExit: () => dashboardApi.setFullScreenMode(false),
    toggleChrome: !dashboardApi.isEmbeddedExternally
  })));
};
const DashboardViewport = () => /*#__PURE__*/_react.default.createElement(WithFullScreenButton, null, /*#__PURE__*/_react.default.createElement(DashboardViewportComponent, null));
exports.DashboardViewport = DashboardViewport;