"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _dashboard_content_management_service = require("../../../services/dashboard_content_management_service");
var _kibana_services = require("../../../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DUPLICATE_TITLE_CALLOUT_ID = 'duplicateTitleCallout';
const DashboardSettings = ({
  onClose
}) => {
  var _localSettings$descri;
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [localSettings, setLocalSettings] = (0, _react.useState)(dashboardApi.getSettings());
  const [isTitleDuplicate, setIsTitleDuplicate] = (0, _react.useState)(false);
  const [isTitleDuplicateConfirmed, setIsTitleDuplicateConfirmed] = (0, _react.useState)(false);
  const [isApplying, setIsApplying] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const onTitleDuplicate = () => {
    if (!isMounted()) return;
    setIsTitleDuplicate(true);
    setIsTitleDuplicateConfirmed(true);
  };
  const onApply = async () => {
    var _dashboardApi$panelTi;
    setIsApplying(true);
    const validTitle = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().checkForDuplicateDashboardTitle({
      title: localSettings.title,
      copyOnSave: false,
      lastSavedTitle: (_dashboardApi$panelTi = dashboardApi.panelTitle.value) !== null && _dashboardApi$panelTi !== void 0 ? _dashboardApi$panelTi : '',
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    });
    if (!isMounted()) return;
    setIsApplying(false);
    if (validTitle) {
      dashboardApi.setSettings(localSettings);
      onClose();
    }
  };
  const updateDashboardSetting = (0, _react.useCallback)(newSettings => {
    setLocalSettings(prevSettings => {
      return {
        ...prevSettings,
        ...newSettings
      };
    });
  }, []);
  const renderDuplicateTitleCallout = () => {
    if (!isTitleDuplicate) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleLabel",
        defaultMessage: "This dashboard already exists"
      }),
      color: "warning",
      "data-test-subj": "duplicateTitleWarningMessage",
      id: DUPLICATE_TITLE_CALLOUT_ID
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleDescription",
      defaultMessage: "Saving ''{title}'' creates a duplicate title.",
      values: {
        title: localSettings.title
      }
    })));
  };
  const renderTagSelector = () => {
    const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
    if (!savedObjectsTaggingApi) return;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.tagsFormRowLabel",
        defaultMessage: "Tags"
      })
    }, /*#__PURE__*/_react.default.createElement(savedObjectsTaggingApi.ui.components.TagSelector, {
      selected: localSettings.tags,
      onTagsSelected: selectedTags => updateDashboardSetting({
        tags: selectedTags
      })
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.title",
    defaultMessage: "Dashboard settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, renderDuplicateTitleCallout(), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "dashboardSettingsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelTitleFormRowLabel",
      defaultMessage: "Title"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "dashboardTitleInput",
    className: "dashboardTitleInputText",
    "data-test-subj": "dashboardTitleInput",
    name: "title",
    type: "text",
    value: localSettings.title,
    onChange: event => {
      setIsTitleDuplicate(false);
      setIsTitleDuplicateConfirmed(false);
      updateDashboardSetting({
        title: event.target.value
      });
    },
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelTitleInputAriaLabel', {
      defaultMessage: 'Change the dashboard title'
    }),
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionFormRowLabel",
      defaultMessage: "Description"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    id: "dashboardDescriptionInput",
    className: "dashboardDescriptionInputText",
    "data-test-subj": "dashboardDescriptionInput",
    name: "description",
    value: (_localSettings$descri = localSettings.description) !== null && _localSettings$descri !== void 0 ? _localSettings$descri : '',
    onChange: event => updateDashboardSetting({
      description: event.target.value
    }),
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionAriaLabel', {
      defaultMessage: 'Change the dashboard description'
    })
  })), renderTagSelector(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowHelpText",
      defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "storeTimeWithDashboard",
    checked: localSettings.timeRestore,
    onChange: event => updateDashboardSetting({
      timeRestore: event.target.checked
    }),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowLabel",
      defaultMessage: "Store time with dashboard"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.useMarginsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Use margins between panels'
    }),
    checked: localSettings.useMargins,
    onChange: event => updateDashboardSetting({
      useMargins: event.target.checked
    }),
    "data-test-subj": "dashboardMarginsCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.hideAllPanelTitlesSwitchLabel', {
      defaultMessage: 'Show panel titles'
    }),
    checked: !localSettings.hidePanelTitles,
    onChange: event => updateDashboardSetting({
      hidePanelTitles: !event.target.checked
    }),
    "data-test-subj": "dashboardPanelTitlesCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.formRow.syncAcrossPanelsLabel', {
      defaultMessage: 'Sync across panels'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncColorsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync color palettes across panels'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.syncColorsBetweenPanelsSwitchHelp",
        defaultMessage: "Only valid for {default} and {compatibility} palettes",
        values: {
          default: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('dashboard.palettes.defaultPaletteLabel', {
            defaultMessage: 'Default'
          })),
          compatibility: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('dashboard.palettes.kibanaPaletteLabel', {
            defaultMessage: 'Compatibility'
          }))
        }
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "questionInCircle"
    })),
    checked: localSettings.syncColors,
    onChange: event => updateDashboardSetting({
      syncColors: event.target.checked
    }),
    "data-test-subj": "dashboardSyncColorsCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncCursorBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync cursor across panels'
    }),
    checked: localSettings.syncCursor,
    onChange: event => {
      const syncCursor = event.target.checked;
      if (!syncCursor && localSettings.syncTooltips) {
        updateDashboardSetting({
          syncCursor,
          syncTooltips: false
        });
      } else {
        updateDashboardSetting({
          syncCursor
        });
      }
    },
    "data-test-subj": "dashboardSyncCursorCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncTooltipsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync tooltips across panels'
    }),
    checked: localSettings.syncTooltips,
    disabled: !Boolean(localSettings.syncCursor),
    onChange: event => updateDashboardSetting({
      syncTooltips: event.target.checked
    }),
    "data-test-subj": "dashboardSyncTooltipsCheckbox"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    "data-test-subj": "cancelCustomizeDashboardButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.cancelButtonTitle",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "applyCustomizeDashboardButton",
    onClick: onApply,
    fill: true,
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined,
    isLoading: isApplying
  }, isTitleDuplicate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.confirmApplyButtonTitle",
    defaultMessage: "Confirm and apply"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.applyButtonTitle",
    defaultMessage: "Apply"
  }))))));
};
exports.DashboardSettings = DashboardSettings;