"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEmptyScreen = DashboardEmptyScreen;
var _react = _interopRequireWildcard(require("react"));
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _dashboard_constants = require("../../../dashboard_constants");
var _kibana_services = require("../../../services/kibana_services");
var _get_dashboard_capabilities = require("../../../utils/get_dashboard_capabilities");
var _dashboard_container_strings = require("../../_dashboard_container_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardEmptyScreen() {
  var _useObservable;
  const lensAlias = (0, _react.useMemo)(() => _kibana_services.visualizationsService.getAliases().find(({
    name
  }) => name === 'lens'), []);
  const {
    showWriteControls
  } = (0, _react.useMemo)(() => {
    return (0, _get_dashboard_capabilities.getDashboardCapabilities)();
  }, []);
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const isDarkTheme = (_useObservable = (0, _useObservable2.default)(_kibana_services.coreServices.theme.theme$)) === null || _useObservable === void 0 ? void 0 : _useObservable.darkMode;
  const viewMode = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.viewMode);
  const isEditMode = (0, _react.useMemo)(() => {
    return viewMode === 'edit';
  }, [viewMode]);
  const goToLens = (0, _react.useCallback)(() => {
    var _appContext$getCurren, _appContext$getCurren2;
    if (!lensAlias || !lensAlias.alias) return;
    const trackUiMetric = _kibana_services.usageCollectionService === null || _kibana_services.usageCollectionService === void 0 ? void 0 : _kibana_services.usageCollectionService.reportUiCounter.bind(_kibana_services.usageCollectionService, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${lensAlias.name}:create`);
    }
    const appContext = dashboardApi.getAppContext();
    _kibana_services.embeddableService.getStateTransfer().navigateToEditor(lensAlias.alias.app, {
      path: lensAlias.alias.path,
      state: {
        originatingApp: appContext === null || appContext === void 0 ? void 0 : appContext.currentAppId,
        originatingPath: (_appContext$getCurren = appContext === null || appContext === void 0 ? void 0 : (_appContext$getCurren2 = appContext.getCurrentPath) === null || _appContext$getCurren2 === void 0 ? void 0 : _appContext$getCurren2.call(appContext)) !== null && _appContext$getCurren !== void 0 ? _appContext$getCurren : '',
        searchSessionId: _kibana_services.dataService.search.session.getSessionId()
      }
    });
  }, [lensAlias, dashboardApi]);

  // TODO replace these SVGs with versions from EuiIllustration as soon as it becomes available.
  const imageUrl = _kibana_services.coreServices.http.basePath.prepend(`/plugins/dashboard/assets/${isDarkTheme ? 'dashboards_dark' : 'dashboards_light'}.svg`);

  // If the user ends up in edit mode without write privileges, we shouldn't show the edit prompt.
  const showEditPrompt = showWriteControls && isEditMode;
  const emptyPromptTestSubject = (() => {
    if (showEditPrompt) return 'emptyDashboardWidget';
    return showWriteControls ? 'dashboardEmptyReadWrite' : 'dashboardEmptyReadOnly';
  })();
  const title = (() => {
    const titleString = showEditPrompt ? _dashboard_container_strings.emptyScreenStrings.getEditModeTitle() : showWriteControls ? _dashboard_container_strings.emptyScreenStrings.getViewModeWithPermissionsTitle() : _dashboard_container_strings.emptyScreenStrings.getViewModeWithoutPermissionsTitle();
    return /*#__PURE__*/_react.default.createElement("h2", null, titleString);
  })();
  const body = (() => {
    const bodyString = showEditPrompt ? _dashboard_container_strings.emptyScreenStrings.getEditModeSubtitle() : showWriteControls ? _dashboard_container_strings.emptyScreenStrings.getViewModeWithPermissionsSubtitle() : _dashboard_container_strings.emptyScreenStrings.getViewModeWithoutPermissionsSubtitle();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("span", null, bodyString));
  })();
  const actions = (() => {
    if (showEditPrompt) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        gutterSize: "l",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "lensApp",
        onClick: () => goToLens()
      }, _dashboard_container_strings.emptyScreenStrings.getCreateVisualizationButtonTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        flush: "left",
        iconType: "folderOpen",
        onClick: () => dashboardApi.addFromLibrary()
      }, _dashboard_container_strings.emptyScreenStrings.getAddFromLibraryButtonTitle())));
    }
    if (showWriteControls) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "pencil",
        onClick: () => dashboardApi.setViewMode(_public.ViewMode.EDIT)
      }, _dashboard_container_strings.emptyScreenStrings.getEditLinkTitle());
    }
  })();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dshEmptyPromptParent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    grow: false,
    "data-test-subj": emptyPromptTestSubject,
    className: "dshEmptyPromptPageTemplate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: imageUrl,
      alt: ""
    }),
    title: title,
    body: body,
    actions: actions,
    titleSize: "xs",
    color: "transparent",
    className: "dshEmptyWidgetContainer"
  })));
}