"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARD_CACHE_TTL = exports.DASHBOARD_CACHE_SIZE = exports.DASHBOARD_APP_ID = exports.CREATE_NEW_DASHBOARD_URL = exports.CHANGE_CHECK_DEBOUNCE = void 0;
Object.defineProperty(exports, "DASHBOARD_CONTENT_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONTENT_ID;
  }
});
exports.VIEW_DASHBOARD_URL = exports.SEARCH_SESSION_ID = exports.SAVED_OBJECT_POST_TIME = exports.SAVED_OBJECT_LOADED_TIME = exports.SAVED_OBJECT_DELETE_TIME = exports.PanelPlacementStrategy = exports.PRINT_DASHBOARD_URL = exports.LEGACY_DASHBOARD_APP_ID = exports.LANDING_PAGE_PATH = exports.GLOBAL_STATE_STORAGE_KEY = exports.DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_HEIGHT = exports.DEFAULT_DASHBOARD_INPUT = exports.DASHBOARD_UI_METRIC_ID = exports.DASHBOARD_STATE_STORAGE_KEY = exports.DASHBOARD_MARGIN_SIZE = exports.DASHBOARD_LOADED_EVENT = exports.DASHBOARD_GRID_HEIGHT = exports.DASHBOARD_GRID_COLUMN_COUNT = void 0;
exports.createDashboardEditUrl = createDashboardEditUrl;
exports.createDashboardListingFilterUrl = createDashboardListingFilterUrl;
exports.getFullPath = exports.getFullEditPath = void 0;
var _common = require("@kbn/embeddable-plugin/common");
var _constants = require("../common/content_management/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// ------------------------------------------------------------------
// URL Constants
// ------------------------------------------------------------------
const DASHBOARD_STATE_STORAGE_KEY = exports.DASHBOARD_STATE_STORAGE_KEY = '_a';
const GLOBAL_STATE_STORAGE_KEY = exports.GLOBAL_STATE_STORAGE_KEY = '_g';
const LANDING_PAGE_PATH = exports.LANDING_PAGE_PATH = '/list';
const CREATE_NEW_DASHBOARD_URL = exports.CREATE_NEW_DASHBOARD_URL = '/create';
const VIEW_DASHBOARD_URL = exports.VIEW_DASHBOARD_URL = '/view';
const PRINT_DASHBOARD_URL = exports.PRINT_DASHBOARD_URL = '/print';
const getFullPath = (aliasId, id) => `/app/dashboards#${createDashboardEditUrl(aliasId || id)}`;
exports.getFullPath = getFullPath;
const getFullEditPath = (id, editMode) => {
  return `/app/dashboards#${createDashboardEditUrl(id, editMode)}`;
};
exports.getFullEditPath = getFullEditPath;
function createDashboardEditUrl(id, editMode) {
  if (!id) {
    return `${CREATE_NEW_DASHBOARD_URL}`;
  }
  const edit = editMode ? `?${DASHBOARD_STATE_STORAGE_KEY}=(viewMode:edit)` : '';
  return `${VIEW_DASHBOARD_URL}/${id}${edit}`;
}
function createDashboardListingFilterUrl(filter) {
  return filter ? `${LANDING_PAGE_PATH}?filter="${filter}"` : LANDING_PAGE_PATH;
}

// ------------------------------------------------------------------
// Telemetry & Events
// ------------------------------------------------------------------
const DASHBOARD_LOADED_EVENT = exports.DASHBOARD_LOADED_EVENT = 'dashboard_loaded';
const SAVED_OBJECT_LOADED_TIME = exports.SAVED_OBJECT_LOADED_TIME = 'saved_object_loaded_time';
const SAVED_OBJECT_DELETE_TIME = exports.SAVED_OBJECT_DELETE_TIME = 'saved_object_delete_time';
const SAVED_OBJECT_POST_TIME = exports.SAVED_OBJECT_POST_TIME = 'saved_object_post_time';
const DASHBOARD_UI_METRIC_ID = exports.DASHBOARD_UI_METRIC_ID = 'dashboard';

// ------------------------------------------------------------------
// IDs
// ------------------------------------------------------------------
const DASHBOARD_APP_ID = exports.DASHBOARD_APP_ID = 'dashboards';
const LEGACY_DASHBOARD_APP_ID = exports.LEGACY_DASHBOARD_APP_ID = 'dashboard';
const SEARCH_SESSION_ID = exports.SEARCH_SESSION_ID = 'searchSessionId';

// ------------------------------------------------------------------
// Grid
// ------------------------------------------------------------------
const DEFAULT_PANEL_HEIGHT = exports.DEFAULT_PANEL_HEIGHT = 15;
const DASHBOARD_MARGIN_SIZE = exports.DASHBOARD_MARGIN_SIZE = 8;
const DASHBOARD_GRID_HEIGHT = exports.DASHBOARD_GRID_HEIGHT = 20;
const DASHBOARD_GRID_COLUMN_COUNT = exports.DASHBOARD_GRID_COLUMN_COUNT = 48;
const DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_WIDTH = DASHBOARD_GRID_COLUMN_COUNT / 2;
const CHANGE_CHECK_DEBOUNCE = exports.CHANGE_CHECK_DEBOUNCE = 100;
let PanelPlacementStrategy = exports.PanelPlacementStrategy = /*#__PURE__*/function (PanelPlacementStrategy) {
  PanelPlacementStrategy["placeAtTop"] = "placeAtTop";
  PanelPlacementStrategy["findTopLeftMostOpenSpace"] = "findTopLeftMostOpenSpace";
  return PanelPlacementStrategy;
}({}); // ------------------------------------------------------------------
// Content Management
// ------------------------------------------------------------------
const DASHBOARD_CACHE_SIZE = exports.DASHBOARD_CACHE_SIZE = 20; // only store a max of 20 dashboards
const DASHBOARD_CACHE_TTL = exports.DASHBOARD_CACHE_TTL = 1000 * 60 * 5; // time to live = 5 minutes

// ------------------------------------------------------------------
// Default State
// ------------------------------------------------------------------
const DEFAULT_DASHBOARD_INPUT = exports.DEFAULT_DASHBOARD_INPUT = {
  viewMode: _common.ViewMode.VIEW,
  timeRestore: false,
  query: {
    query: '',
    language: 'kuery'
  },
  description: '',
  filters: [],
  panels: {},
  title: '',
  tags: [],
  executionContext: {
    type: 'dashboard'
  },
  // options
  useMargins: true,
  syncColors: false,
  syncCursor: true,
  syncTooltips: false,
  hidePanelTitles: false
};