"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowShareModal = ShowShareModal;
exports.showPublicUrlSwitch = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _common = require("../../../../common");
var _dashboard_backup_service = require("../../../services/dashboard_backup_service");
var _kibana_services = require("../../../services/kibana_services");
var _get_dashboard_capabilities = require("../../../utils/get_dashboard_capabilities");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _dashboard_router = require("../../dashboard_router");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const showFilterBarId = 'showFilterBar';
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.dashboard) return false;
  const dashboard = anonymousUserCapabilities.dashboard;
  return !!dashboard.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;
function ShowShareModal({
  isDirty,
  anchorElement,
  savedObjectId,
  dashboardTitle,
  getPanelsState
}) {
  var _getDashboardBackupSe, _g2;
  if (!_kibana_services.shareService) return;
  const EmbedUrlParamExtension = ({
    setParamValue
  }) => {
    const [urlParamsSelectedMap, seturlParamsSelectedMap] = (0, _react.useState)({
      showFilterBar: true
    });
    const checkboxes = [{
      id: _dashboard_router.dashboardUrlParams.showTopMenu,
      label: _dashboard_app_strings.shareModalStrings.getTopMenuCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showQueryInput,
      label: _dashboard_app_strings.shareModalStrings.getQueryCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showTimeFilter,
      label: _dashboard_app_strings.shareModalStrings.getTimeFilterCheckbox()
    }, {
      id: showFilterBarId,
      label: _dashboard_app_strings.shareModalStrings.getFilterBarCheckbox()
    }];
    const handleChange = param => {
      const newSelectedMap = {
        ...urlParamsSelectedMap,
        [param]: !urlParamsSelectedMap[param]
      };
      const urlParamValues = {
        [_dashboard_router.dashboardUrlParams.showTopMenu]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTopMenu],
        [_dashboard_router.dashboardUrlParams.showQueryInput]: newSelectedMap[_dashboard_router.dashboardUrlParams.showQueryInput],
        [_dashboard_router.dashboardUrlParams.showTimeFilter]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTimeFilter],
        [_dashboard_router.dashboardUrlParams.hideFilterBar]: !newSelectedMap[showFilterBarId]
      };
      seturlParamsSelectedMap(newSelectedMap);
      setParamValue(urlParamValues);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
      options: checkboxes,
      idToSelectedMap: urlParamsSelectedMap,
      onChange: handleChange,
      legend: {
        children: _dashboard_app_strings.shareModalStrings.getCheckboxLegend()
      },
      "data-test-subj": "embedUrlParamExtension"
    });
  };
  let unsavedStateForLocator = {};
  const {
    dashboardState: unsavedDashboardState,
    panels: panelModifications
  } = (_getDashboardBackupSe = (0, _dashboard_backup_service.getDashboardBackupService)().getState(savedObjectId)) !== null && _getDashboardBackupSe !== void 0 ? _getDashboardBackupSe : {};
  const allUnsavedPanels = (_unsavedDashboardStat => {
    if (Object.keys((_unsavedDashboardStat = unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.panels) !== null && _unsavedDashboardStat !== void 0 ? _unsavedDashboardStat : {}).length === 0 && Object.keys(panelModifications !== null && panelModifications !== void 0 ? panelModifications : {}).length === 0) {
      // if this dashboard has no modifications or unsaved panels return early. No overrides needed.
      return;
    }
    const latestPanels = getPanelsState();
    // apply modifications to panels.
    const modifiedPanels = panelModifications ? Object.entries(panelModifications).reduce((acc, [panelId, unsavedPanel]) => {
      if (unsavedPanel && latestPanels !== null && latestPanels !== void 0 && latestPanels[panelId]) {
        acc[panelId] = {
          ...latestPanels[panelId],
          explicitInput: {
            ...(latestPanels === null || latestPanels === void 0 ? void 0 : latestPanels[panelId].explicitInput),
            ...unsavedPanel,
            id: panelId
          }
        };
      }
      return acc;
    }, {}) : {};

    // The latest state of panels to share. This will overwrite panels from the saved object on Dashboard load.
    const allUnsavedPanelsMap = {
      ...latestPanels,
      ...modifiedPanels
    };
    return (0, _common.convertPanelMapToSavedPanels)(allUnsavedPanelsMap);
  })();
  if (unsavedDashboardState) {
    unsavedStateForLocator = {
      query: unsavedDashboardState.query,
      filters: unsavedDashboardState.filters,
      controlGroupState: panelModifications === null || panelModifications === void 0 ? void 0 : panelModifications[_dashboard_backup_service.PANELS_CONTROL_GROUP_KEY],
      panels: allUnsavedPanels,
      // options
      useMargins: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.useMargins,
      syncColors: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncColors,
      syncCursor: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncCursor,
      syncTooltips: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncTooltips,
      hidePanelTitles: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.hidePanelTitles
    };
  }
  const locatorParams = {
    dashboardId: savedObjectId,
    preserveSavedFilters: true,
    refreshInterval: undefined,
    // We don't share refresh interval externally
    viewMode: _public.ViewMode.VIEW,
    // For share locators we always load the dashboard in view mode
    useHash: false,
    timeRange: _kibana_services.dataService.query.timefilter.timefilter.getTime(),
    ...unsavedStateForLocator
  };
  let _g = (0, _public2.getStateFromKbnUrl)('_g', window.location.href);
  if ((_g2 = _g) !== null && _g2 !== void 0 && _g2.filters && _g.filters.length === 0) {
    _g = (0, _lodash.omit)(_g, 'filters');
  }
  const baseUrl = (0, _public2.setStateToKbnUrl)('_g', _g, undefined, window.location.href);
  const shareableUrl = (0, _public2.setStateToKbnUrl)('_a', unsavedStateForLocator, {
    useHash: false,
    storeInHashQuery: true
  }, (0, _public2.unhashUrl)(baseUrl));
  _kibana_services.shareService.toggleShareContextMenu({
    isDirty,
    anchorElement,
    allowEmbed: true,
    allowShortUrl: (0, _get_dashboard_capabilities.getDashboardCapabilities)().createShortUrl,
    shareableUrl,
    objectId: savedObjectId,
    objectType: 'dashboard',
    objectTypeMeta: {
      title: _i18n.i18n.translate('dashboard.share.shareModal.title', {
        defaultMessage: 'Share this dashboard'
      })
    },
    sharingData: {
      title: dashboardTitle || _i18n.i18n.translate('dashboard.share.defaultDashboardTitle', {
        defaultMessage: 'Dashboard [{date}]',
        values: {
          date: (0, _moment.default)().toISOString(true)
        }
      }),
      locatorParams: {
        id: _deeplinksAnalytics.DASHBOARD_APP_LOCATOR,
        params: locatorParams
      }
    },
    embedUrlParamExtensions: [{
      paramName: 'embed',
      component: EmbedUrlParamExtension
    }],
    showPublicUrlSwitch,
    snapshotShareWarning: Boolean(unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.panels) ? _dashboard_app_strings.shareModalStrings.getSnapshotShareWarning() : undefined,
    toasts: _kibana_services.coreServices.notifications.toasts
  });
}