"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
require("./editor_menu.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _add_new_panel = require("./add_new_panel");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EditorMenu = ({
  createNewVisType,
  isDisabled
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const fetchDashboardPanels = (0, _add_new_panel.useGetDashboardPanels)({
    api: dashboardApi,
    createNewVisType
  });
  (0, _react.useEffect)(() => {
    // ensure opened dashboard is closed if a navigation event happens;
    return () => {
      dashboardApi.clearOverlays();
    };
  }, [dashboardApi]);
  const openDashboardPanelSelectionFlyout = (0, _react.useCallback)(function openDashboardPanelSelectionFlyout() {
    const flyoutPanelPaddingSize = 'l';
    const mount = (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(function () {
      return /*#__PURE__*/_react.default.createElement(_add_new_panel.DashboardPanelSelectionListFlyout, {
        close: dashboardApi.clearOverlays,
        paddingSize: flyoutPanelPaddingSize,
        fetchDashboardPanels: fetchDashboardPanels.bind(null, dashboardApi.clearOverlays)
      });
    }), {
      analytics: _kibana_services.coreServices.analytics,
      theme: _kibana_services.coreServices.theme,
      i18n: _kibana_services.coreServices.i18n
    });
    dashboardApi.openOverlay(_kibana_services.coreServices.overlays.openFlyout(mount, {
      size: 'm',
      maxWidth: 500,
      paddingSize: flyoutPanelPaddingSize,
      'aria-labelledby': 'addPanelsFlyout',
      'data-test-subj': 'dashboardPanelSelectionFlyout',
      onClose(overlayRef) {
        dashboardApi.clearOverlays();
        overlayRef.close();
      }
    }));
  }, [dashboardApi, fetchDashboardPanels]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
    "data-test-subj": "dashboardEditorMenuButton",
    isDisabled: isDisabled,
    iconType: "plusInCircle",
    label: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
      defaultMessage: 'Add panel'
    }),
    onClick: openDashboardPanelSelectionFlyout,
    size: "s"
  });
};
exports.EditorMenu = EditorMenu;