"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEditingToolbar = DashboardEditingToolbar;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _react2 = _interopRequireWildcard(require("react"));
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _dashboard_constants = require("../../dashboard_constants");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _controls_toolbar_button = require("./controls_toolbar_button");
var _editor_menu = require("./editor_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardEditingToolbar({
  isDisabled
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const lensAlias = (0, _react2.useMemo)(() => _kibana_services.visualizationsService.getAliases().find(({
    name
  }) => name === 'lens'), []);
  const createNewVisType = (0, _react2.useCallback)(visType => () => {
    var _dashboardApi$getAppC, _dashboardApi$getAppC2, _dashboardApi$getAppC3;
    let path = '';
    let appId = '';
    if (visType) {
      const trackUiMetric = _kibana_services.usageCollectionService === null || _kibana_services.usageCollectionService === void 0 ? void 0 : _kibana_services.usageCollectionService.reportUiCounter.bind(_kibana_services.usageCollectionService, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
      if (trackUiMetric) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if (!('alias' in visType)) {
        // this visualization is not an alias
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      } else if (visType.alias && 'path' in visType.alias) {
        // this visualization **is** an alias, and it has an app to redirect to for creation
        appId = visType.alias.app;
        path = visType.alias.path;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    const stateTransferService = _kibana_services.embeddableService.getStateTransfer();
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: (_dashboardApi$getAppC = dashboardApi.getAppContext()) === null || _dashboardApi$getAppC === void 0 ? void 0 : _dashboardApi$getAppC.currentAppId,
        originatingPath: (_dashboardApi$getAppC2 = dashboardApi.getAppContext()) === null || _dashboardApi$getAppC2 === void 0 ? void 0 : (_dashboardApi$getAppC3 = _dashboardApi$getAppC2.getCurrentPath) === null || _dashboardApi$getAppC3 === void 0 ? void 0 : _dashboardApi$getAppC3.call(_dashboardApi$getAppC2),
        searchSessionId: _kibana_services.dataService.search.session.getSessionId()
      }
    });
  }, [dashboardApi]);

  /**
   * embeddableFactory: Required, you can get the factory from embeddableStart.getEmbeddableFactory(<embeddable type, i.e. lens>)
   * initialInput: Optional, use it in case you want to pass your own input to the factory
   * dismissNotification: Optional, if not passed a toast will appear in the dashboard
   */

  const controlGroupApi = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.controlGroupApi$);
  const extraButtons = [/*#__PURE__*/_react2.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    isDisabled: isDisabled
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
    onClick: () => dashboardApi.addFromLibrary(),
    size: "s",
    "data-test-subj": "dashboardAddFromLibraryButton",
    isDisabled: isDisabled
  }), /*#__PURE__*/_react2.default.createElement(_controls_toolbar_button.ControlsToolbarButton, {
    isDisabled: isDisabled,
    controlGroupApi: controlGroupApi
  })];
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        padding: 0 ${euiTheme.size.s} ${euiTheme.size.s} ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      type: "primary",
      isDisabled: isDisabled,
      iconType: "lensApp",
      size: "s",
      onClick: createNewVisType(lensAlias),
      label: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      "data-test-subj": "dashboardAddNewPanelButton"
    }),
    extraButtons
  }));
}