"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDashboardPanels = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _kibana_services = require("../../../services/kibana_services");
var _add_panel_action_menu_items = require("./add_panel_action_menu_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sortGroupPanelsByOrder = panelGroups => {
  return panelGroups.sort(
  // larger number sorted to the top
  (panelGroupA, panelGroupB) => panelGroupB.order - panelGroupA.order);
};
const useGetDashboardPanels = ({
  api,
  createNewVisType
}) => {
  const panelsComputeResultCache = (0, _react.useRef)(new _rxjs.AsyncSubject());
  const panelsComputeSubscription = (0, _react.useRef)(null);
  const getSortedVisTypesByGroup = group => _kibana_services.visualizationsService.getByGroup(group).sort((a, b) => {
    const labelA = 'titleInWizard' in a ? a.titleInWizard || a.title : a.title;
    const labelB = 'titleInWizard' in b ? b.titleInWizard || a.title : a.title;
    if (labelA < labelB) {
      return -1;
    }
    if (labelA > labelB) {
      return 1;
    }
    return 0;
  }).filter(({
    disableCreate
  }) => !disableCreate);
  const promotedVisTypes = getSortedVisTypesByGroup(_public3.VisGroups.PROMOTED);
  const toolVisTypes = getSortedVisTypesByGroup(_public3.VisGroups.TOOLS);
  const legacyVisTypes = getSortedVisTypesByGroup(_public3.VisGroups.LEGACY);
  const visTypeAliases = _kibana_services.visualizationsService.getAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1).filter(({
    disableCreate
  }) => !disableCreate);
  const augmentedCreateNewVisType = (0, _react.useCallback)((visType, cb) => {
    const visClickHandler = createNewVisType(visType);
    return () => {
      visClickHandler();
      cb();
    };
  }, [createNewVisType]);
  const getVisTypeMenuItem = (0, _react.useCallback)((onClickCb, visType) => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty',
      isDeprecated,
      order
    } = visType;
    return {
      id: name,
      name: titleInWizard || title,
      isDeprecated,
      icon,
      onClick: augmentedCreateNewVisType(visType, onClickCb),
      'data-test-subj': `visType-${name}`,
      description,
      order
    };
  }, [augmentedCreateNewVisType]);
  const getVisTypeAliasMenuItem = (0, _react.useCallback)((onClickCb, visTypeAlias) => {
    const {
      name,
      title,
      description,
      icon = 'empty',
      order
    } = visTypeAlias;
    return {
      id: name,
      name: title,
      icon,
      onClick: augmentedCreateNewVisType(visTypeAlias, onClickCb),
      'data-test-subj': `visType-${name}`,
      description,
      order: order !== null && order !== void 0 ? order : 0
    };
  }, [augmentedCreateNewVisType]);
  const addPanelAction$ = (0, _react.useMemo)(() => (0, _rxjs.defer)(() => {
    var _uiActionsService$get, _uiActionsService$get2;
    return (0, _rxjs.from)((_uiActionsService$get = (_uiActionsService$get2 = _kibana_services.uiActionsService.getTriggerCompatibleActions) === null || _uiActionsService$get2 === void 0 ? void 0 : _uiActionsService$get2.call(_kibana_services.uiActionsService, _public2.ADD_PANEL_TRIGGER, {
      embeddable: api
    })) !== null && _uiActionsService$get !== void 0 ? _uiActionsService$get : []);
  }), [api]);
  const computeAvailablePanels = (0, _react.useCallback)(onPanelSelected => {
    if (!panelsComputeSubscription.current) {
      panelsComputeSubscription.current = addPanelAction$.pipe((0, _rxjs.map)(addPanelActions => (0, _add_panel_action_menu_items.getAddPanelActionMenuItemsGroup)(api, addPanelActions, onPanelSelected)), (0, _rxjs.map)(groupedAddPanelAction => {
        return sortGroupPanelsByOrder(Object.values(groupedAddPanelAction)).map(panelGroup => {
          switch (panelGroup.id) {
            case 'visualizations':
              {
                var _panelGroup$items;
                return {
                  ...panelGroup,
                  items: sortGroupPanelsByOrder(((_panelGroup$items = panelGroup.items) !== null && _panelGroup$items !== void 0 ? _panelGroup$items : []).concat(
                  // TODO: actually add grouping to vis type alias so we wouldn't randomly display an unintended item
                  visTypeAliases.map(getVisTypeAliasMenuItem.bind(null, onPanelSelected)), promotedVisTypes.map(getVisTypeMenuItem.bind(null, onPanelSelected))))
                };
              }
            case _public.COMMON_EMBEDDABLE_GROUPING.legacy.id:
              {
                var _panelGroup$items2;
                return {
                  ...panelGroup,
                  items: sortGroupPanelsByOrder(((_panelGroup$items2 = panelGroup.items) !== null && _panelGroup$items2 !== void 0 ? _panelGroup$items2 : []).concat(legacyVisTypes.map(getVisTypeMenuItem.bind(null, onPanelSelected))))
                };
              }
            case _public.COMMON_EMBEDDABLE_GROUPING.annotation.id:
              {
                var _panelGroup$items3;
                return {
                  ...panelGroup,
                  items: sortGroupPanelsByOrder(((_panelGroup$items3 = panelGroup.items) !== null && _panelGroup$items3 !== void 0 ? _panelGroup$items3 : []).concat(toolVisTypes.map(getVisTypeMenuItem.bind(null, onPanelSelected))))
                };
              }
            default:
              {
                return {
                  ...panelGroup,
                  items: sortGroupPanelsByOrder(panelGroup.items)
                };
              }
          }
        });
      })).subscribe(panelsComputeResultCache.current);
    }
  }, [api, addPanelAction$, getVisTypeMenuItem, getVisTypeAliasMenuItem, toolVisTypes, legacyVisTypes, promotedVisTypes, visTypeAliases]);
  return (0, _react.useCallback)((...args) => {
    computeAvailablePanels(...args);
    return (0, _rxjs.lastValueFrom)(panelsComputeResultCache.current.asObservable());
  }, [computeAvailablePanels]);
};
exports.useGetDashboardPanels = useGetDashboardPanels;