"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPanelSelectionListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _orderBy = _interopRequireDefault(require("lodash/orderBy"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardPanelSelectionListFlyout = ({
  close,
  paddingSize,
  fetchDashboardPanels
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [{
    data: panels,
    loading,
    error
  }, setPanelState] = (0, _react.useState)({
    loading: true,
    data: null,
    error: null
  });
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [panelsSearchResult, setPanelsSearchResult] = (0, _react.useState)(panels);
  (0, _react.useEffect)(() => {
    const requestDashboardPanels = () => {
      fetchDashboardPanels().then(_panels => setPanelState(prevState => ({
        ...prevState,
        loading: false,
        data: _panels
      }))).catch(err => setPanelState(prevState => ({
        ...prevState,
        loading: false,
        error: err
      })));
    };
    requestDashboardPanels();
  }, [fetchDashboardPanels]);
  (0, _react.useEffect)(() => {
    const _panels = (panels !== null && panels !== void 0 ? panels : []).slice(0);
    if (!searchTerm) {
      return setPanelsSearchResult(_panels);
    }
    const q = searchTerm.toLowerCase();
    setPanelsSearchResult((0, _orderBy.default)(_panels.map(panel => {
      const groupSearchMatch = panel.title.toLowerCase().includes(q);
      const [groupSearchMatchAgg, items] = panel.items.reduce((acc, cur) => {
        const searchMatch = cur.name.toLowerCase().includes(q);
        acc[0] = acc[0] || searchMatch;
        acc[1].push({
          ...cur,
          isDisabled: !(groupSearchMatch || searchMatch)
        });
        return acc;
      }, [groupSearchMatch, []]);
      return {
        ...panel,
        isDisabled: !groupSearchMatchAgg,
        items
      };
    }), ['isDisabled']));
  }, [panels, searchTerm]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "addPanelsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.headingText",
    defaultMessage: "Add panel"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'sticky',
      top: euiTheme.size[paddingSize],
      zIndex: 1,
      boxShadow: `0 -${euiTheme.size[paddingSize]} 0 4px ${euiTheme.colors.emptyShade}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      backgroundColor: euiTheme.colors.emptyShade
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    autoFocus: true,
    value: searchTerm,
    onChange: e => {
      setSearchTerm(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('dashboard.editorMenu.addPanelFlyout.searchLabelText', {
      defaultMessage: 'search field for panels'
    }),
    className: "nsPanelSelectionFlyout__searchInput",
    "data-test-subj": "dashboardPanelSelectionFlyout__searchInput"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minHeight: '20vh',
      ...(loading || error ? {
        justifyContent: 'center',
        alignItems: 'center'
      } : {})
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "dashboardPanelSelectionLoadingIndicator",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "l",
      mono: true
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "dashboardPanelSelectionList"
  }, panelsSearchResult !== null && panelsSearchResult !== void 0 && panelsSearchResult.some(({
    isDisabled
  }) => !isDisabled) ? panelsSearchResult.map(({
    id,
    title,
    items,
    isDisabled,
    ['data-test-subj']: dataTestSubj,
    order
  }) => !isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id,
    "data-test-subj": dataTestSubj,
    "data-group-sort-order": order
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: `${id}-group`,
    size: "xxs"
  }, typeof title === 'string' ? /*#__PURE__*/_react.default.createElement("h3", null, title) : title), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "aria-labelledby": `${id}-group`,
    size: "s",
    gutterSize: "none",
    maxWidth: false,
    flush: true
  }, items === null || items === void 0 ? void 0 : items.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      key: `${id}.${idx}`,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: item.description
      }, !item.isDeprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, item.name) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, item.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.editorMenu.deprecatedTag",
        defaultMessage: "Deprecated"
      }))))),
      onClick: item === null || item === void 0 ? void 0 : item.onClick,
      iconType: item.icon,
      "data-test-subj": item['data-test-subj'],
      isDisabled: item.isDisabled
    });
  }))) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Boolean(error) ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.solutionToolbar.addPanelFlyout.loadingErrorDescription",
      defaultMessage: "An error occurred loading the available dashboard panels for selection"
    })),
    "data-test-subj": "dashboardPanelSelectionErrorIndicator"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    "data-test-subj": "dashboardPanelSelectionNoPanelMessage"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.noResultsDescription",
    defaultMessage: "No panel types found"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: close,
    "data-test-subj": "dashboardPanelSelectionCloseBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.cancelButtonText",
    defaultMessage: "Close"
  }))))));
};
exports.DashboardPanelSelectionListFlyout = DashboardPanelSelectionListFlyout;