"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddPanelActionMenuItemsGroup = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const onAddPanelActionClick = (action, context, closePopover) => event => {
  closePopover();
  if (event.currentTarget instanceof HTMLAnchorElement) {
    if (!event.defaultPrevented &&
    // onClick prevented default
    event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
      event.preventDefault();
      action.execute(context);
    }
  } else action.execute(context);
};
const getAddPanelActionMenuItemsGroup = (api, actions, onPanelSelected) => {
  const grouped = {};
  const context = {
    embeddable: api,
    trigger: _public.addPanelMenuTrigger
  };
  const getMenuItem = item => {
    var _ref, _item$getDisplayNameT, _item$order;
    const actionName = item.getDisplayName(context);
    return {
      id: item.id,
      name: actionName,
      icon: (_ref = typeof item.getIconType === 'function' ? item.getIconType(context) : undefined) !== null && _ref !== void 0 ? _ref : 'empty',
      onClick: onAddPanelActionClick(item, context, onPanelSelected),
      'data-test-subj': `create-action-${actionName}`,
      description: item === null || item === void 0 ? void 0 : (_item$getDisplayNameT = item.getDisplayNameTooltip) === null || _item$getDisplayNameT === void 0 ? void 0 : _item$getDisplayNameT.call(item, context),
      order: (_item$order = item.order) !== null && _item$order !== void 0 ? _item$order : 0
    };
  };
  actions === null || actions === void 0 ? void 0 : actions.forEach(item => {
    if (Array.isArray(item.grouping)) {
      item.grouping.forEach(group => {
        const groupId = group.id;
        if (!grouped[groupId]) {
          var _group$order;
          grouped[groupId] = {
            id: groupId,
            title: group.getDisplayName ? group.getDisplayName(context) : '',
            'data-test-subj': `dashboardEditorMenu-${groupId}Group`,
            order: (_group$order = group.order) !== null && _group$order !== void 0 ? _group$order : 0,
            items: []
          };
        }
        grouped[group.id].items.push(getMenuItem(item));
      });
    } else {
      // use other group as the default for definitions that don't have a group
      const fallbackGroup = _public2.COMMON_EMBEDDABLE_GROUPING.other;
      if (!grouped[fallbackGroup.id]) {
        var _fallbackGroup$getDis;
        grouped[fallbackGroup.id] = {
          id: fallbackGroup.id,
          title: ((_fallbackGroup$getDis = fallbackGroup.getDisplayName) === null || _fallbackGroup$getDis === void 0 ? void 0 : _fallbackGroup$getDis.call(fallbackGroup, {
            embeddable: api
          })) || '',
          'data-test-subj': `dashboardEditorMenu-${fallbackGroup.id}Group`,
          order: fallbackGroup.order || 0,
          items: []
        };
      }
      grouped[fallbackGroup.id].items.push(getMenuItem(item));
    }
  });
  return grouped;
};
exports.getAddPanelActionMenuItemsGroup = getAddPanelActionMenuItemsGroup;