"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTabTitleSetter = void 0;
var _react = require("react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardTabTitleSetter = ({
  dashboardApi
}) => {
  const [title, lastSavedId] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.panelTitle, dashboardApi.savedObjectId);

  /**
   * Set chrome tab title when dashboard's title changes
   */
  (0, _react.useEffect)(() => {
    _kibana_services.coreServices.chrome.docTitle.change(!lastSavedId ? (0, _dashboard_app_strings.getNewDashboardTitle)() : title !== null && title !== void 0 ? title : lastSavedId);
  }, [title, lastSavedId]);
  return null;
};
exports.DashboardTabTitleSetter = DashboardTabTitleSetter;