"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDashboardAppInNoDataState = exports.DashboardAppNoDataPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _dashboard_constants = require("../../dashboard_constants");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../../services/dashboard_content_management_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DashboardAppNoDataPage = ({
  onDataViewCreated
}) => {
  const analyticsServices = {
    coreStart: _kibana_services.coreServices,
    dataViews: _kibana_services.dataService.dataViews,
    dataViewEditor: _kibana_services.dataViewEditorService,
    noDataPage: _kibana_services.noDataPageService,
    share: _kibana_services.shareService
  };
  const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
  const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPageKibanaProvider: NoDataProvider
  }) => {
    return {
      default: NoDataProvider
    };
  })));
  const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPage: NoDataPage
  }) => {
    return {
      default: NoDataPage
    };
  })));
  return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated
  }));
};
exports.DashboardAppNoDataPage = DashboardAppNoDataPage;
const isDashboardAppInNoDataState = async () => {
  const hasUserDataView = await _kibana_services.dataService.dataViews.hasData.hasUserDataView().catch(() => false);
  if (hasUserDataView) return false;

  // consider has data if there is an incoming embeddable
  const hasIncomingEmbeddable = _kibana_services.embeddableService.getStateTransfer().getIncomingEmbeddablePackage(_dashboard_constants.DASHBOARD_APP_ID, false);
  if (hasIncomingEmbeddable) return false;

  // consider has data if there is unsaved dashboard with edits
  if ((0, _dashboard_backup_service.getDashboardBackupService)().dashboardHasUnsavedEdits()) return false;

  // consider has data if there is at least one dashboard
  const {
    total
  } = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().findDashboards.search({
    search: '',
    size: 1
  }).catch(() => ({
    total: 0
  }));
  if (total > 0) return false;
  return true;
};
exports.isDashboardAppInNoDataState = isDashboardAppInNoDataState;