"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistantContext = useObservabilityAIAssistantContext;
var _esqlUtils = require("@kbn/esql-utils");
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
var _react = require("react");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const chartTypes = ['xy', 'pie', 'heatmap', 'metric', 'gauge', 'donut', 'mosaic', 'regionmap', 'table', 'tagcloud', 'treemap'];
function useObservabilityAIAssistantContext({
  dashboardApi
}) {
  (0, _react.useEffect)(() => {
    if (!_kibana_services.observabilityAssistantService) {
      return;
    }
    const {
      service: {
        setScreenContext
      },
      createScreenContextAction
    } = _kibana_services.observabilityAssistantService;
    return setScreenContext({
      screenDescription: 'The user is looking at the dashboard app. Here they can add visualizations to a dashboard and save them',
      actions: dashboardApi ? [createScreenContextAction({
        name: 'add_to_dashboard',
        description: 'Add an ES|QL visualization to the current dashboard. Pick a single chart type, and based on the chart type, the corresponding key for `layers`. E.g., when you select type:metric, fill in only layers.metric.',
        parameters: {
          type: 'object',
          properties: {
            esql: {
              type: 'object',
              properties: {
                query: {
                  type: 'string',
                  description: 'The ES|QL query for this visualization. Use the "query" function to generate ES|QL first and then add it here.'
                }
              },
              required: ['query']
            },
            type: {
              type: 'string',
              description: 'The type of chart',
              enum: chartTypes
            },
            layers: {
              type: 'object',
              properties: {
                xy: {
                  type: 'object',
                  properties: {
                    xAxis: {
                      type: 'string'
                    },
                    yAxis: {
                      type: 'string'
                    },
                    type: {
                      type: 'string',
                      enum: ['line', 'bar', 'area']
                    }
                  }
                },
                donut: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  }
                },
                metric: {
                  type: 'object'
                },
                gauge: {
                  type: 'object'
                },
                pie: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  }
                },
                heatmap: {
                  type: 'object',
                  properties: {
                    xAxis: {
                      type: 'string'
                    },
                    breakdown: {
                      type: 'string'
                    }
                  },
                  required: ['xAxis']
                },
                mosaic: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  },
                  required: ['breakdown']
                },
                regionmap: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  },
                  required: ['breakdown']
                },
                table: {
                  type: 'object'
                },
                tagcloud: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  },
                  required: ['breakdown']
                },
                treemap: {
                  type: 'object',
                  properties: {
                    breakdown: {
                      type: 'string'
                    }
                  }
                }
              }
            },
            title: {
              type: 'string',
              description: 'An optional title for the visualization.'
            }
          },
          required: ['esql', 'type']
        }
      }, async ({
        args,
        signal
      }) => {
        var _columns$find, _layers$xy, _layers$xy2, _layers$xy3, _layers$donut, _layers$pie, _layers$heatmap, _layers$heatmap2, _layers$mosaic, _layers$regionmap, _layers$tagcloud, _layers$treemap;
        const {
          title = '',
          type: chartType = 'xy',
          layers,
          esql: {
            query
          }
        } = args;
        const [columns] = await Promise.all([(0, _esqlUtils.getESQLQueryColumns)({
          esqlQuery: query,
          search: _kibana_services.dataService.search.search,
          signal
        })]);
        const configBuilder = new _config_builder.LensConfigBuilder(_kibana_services.dataService.dataViews);
        let config;
        const firstMetricColumn = (_columns$find = columns.find(column => column.meta.type === 'number')) === null || _columns$find === void 0 ? void 0 : _columns$find.id;
        const dataset = {
          esql: query
        };
        switch (chartType) {
          default:
          case 'xy':
            const xyConfig = {
              chartType: 'xy',
              layers: [{
                seriesType: (layers === null || layers === void 0 ? void 0 : (_layers$xy = layers.xy) === null || _layers$xy === void 0 ? void 0 : _layers$xy.type) || 'line',
                type: 'series',
                xAxis: (layers === null || layers === void 0 ? void 0 : (_layers$xy2 = layers.xy) === null || _layers$xy2 === void 0 ? void 0 : _layers$xy2.xAxis) || '@timestamp',
                yAxis: [{
                  value: (layers === null || layers === void 0 ? void 0 : (_layers$xy3 = layers.xy) === null || _layers$xy3 === void 0 ? void 0 : _layers$xy3.yAxis) || firstMetricColumn
                }]
              }],
              dataset,
              title
            };
            config = xyConfig;
            break;
          case 'donut':
            const donutConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: [layers === null || layers === void 0 ? void 0 : (_layers$donut = layers.donut) === null || _layers$donut === void 0 ? void 0 : _layers$donut.breakdown],
              dataset
            };
            config = donutConfig;
            break;
          case 'pie':
            const pieConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: [layers === null || layers === void 0 ? void 0 : (_layers$pie = layers.pie) === null || _layers$pie === void 0 ? void 0 : _layers$pie.breakdown],
              dataset
            };
            config = pieConfig;
            break;
          case 'metric':
            const metricConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              dataset
            };
            config = metricConfig;
            break;
          case 'gauge':
            const gaugeConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              dataset
            };
            config = gaugeConfig;
            break;
          case 'heatmap':
            const heatmapConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: layers === null || layers === void 0 ? void 0 : (_layers$heatmap = layers.heatmap) === null || _layers$heatmap === void 0 ? void 0 : _layers$heatmap.breakdown,
              xAxis: (layers === null || layers === void 0 ? void 0 : (_layers$heatmap2 = layers.heatmap) === null || _layers$heatmap2 === void 0 ? void 0 : _layers$heatmap2.xAxis) || '@timestamp',
              dataset
            };
            config = heatmapConfig;
            break;
          case 'mosaic':
            const mosaicConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: [(layers === null || layers === void 0 ? void 0 : (_layers$mosaic = layers.mosaic) === null || _layers$mosaic === void 0 ? void 0 : _layers$mosaic.breakdown) || '@timestamp'],
              dataset
            };
            config = mosaicConfig;
            break;
          case 'regionmap':
            const regionMapConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: layers === null || layers === void 0 ? void 0 : (_layers$regionmap = layers.regionmap) === null || _layers$regionmap === void 0 ? void 0 : _layers$regionmap.breakdown,
              dataset
            };
            config = regionMapConfig;
            break;
          case 'table':
            const tableConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              dataset
            };
            config = tableConfig;
            break;
          case 'tagcloud':
            const tagCloudConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: layers === null || layers === void 0 ? void 0 : (_layers$tagcloud = layers.tagcloud) === null || _layers$tagcloud === void 0 ? void 0 : _layers$tagcloud.breakdown,
              dataset
            };
            config = tagCloudConfig;
            break;
          case 'treemap':
            const treeMapConfig = {
              chartType,
              title,
              value: firstMetricColumn,
              breakdown: [(layers === null || layers === void 0 ? void 0 : (_layers$treemap = layers.treemap) === null || _layers$treemap === void 0 ? void 0 : _layers$treemap.breakdown) || '@timestamp'],
              dataset
            };
            config = treeMapConfig;
            break;
        }
        const embeddableInput = await configBuilder.build(config, {
          embeddable: true,
          query: dataset
        });
        return dashboardApi.addNewPanel({
          panelType: 'lens',
          initialState: embeddableInput
        }).then(() => {
          return {
            content: 'Visualization successfully added to dashboard'
          };
        }).catch(error => {
          return {
            content: {
              error
            }
          };
        });
      })] : []
    });
  }, [dashboardApi]);
}