"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardUrlParams = void 0;
exports.mountApp = mountApp;
require("./_dashboard_app.scss");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _dashboard_constants = require("../dashboard_constants");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _dashboard_app_strings = require("./_dashboard_app_strings");
var _dashboard_app2 = require("./dashboard_app");
var _dashboard_mount_context = require("./hooks/dashboard_mount_context");
var _dashboard_listing_page = require("./listing_page/dashboard_listing_page");
var _dashboard_no_match = require("./listing_page/dashboard_no_match");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardUrlParams = exports.dashboardUrlParams = {
  showTopMenu: 'show-top-menu',
  showQueryInput: 'show-query-input',
  showTimeFilter: 'show-time-filter',
  hideFilterBar: 'hide-filter-bar'
};
async function mountApp({
  coreStart,
  element,
  appUnMounted,
  mountContext
}) {
  let globalEmbedSettings;
  const getUrlStateStorage = history => (0, _public2.createKbnUrlStateStorage)({
    history,
    useHash: _kibana_services.coreServices.uiSettings.get('state:storeInSessionStorage'),
    ...(0, _public2.withNotifyOnErrors)(_kibana_services.coreServices.notifications.toasts)
  });
  const redirect = redirectTo => {
    let path;
    let state;
    if (redirectTo.destination === 'dashboard') {
      path = redirectTo.id ? (0, _dashboard_constants.createDashboardEditUrl)(redirectTo.id) : _dashboard_constants.CREATE_NEW_DASHBOARD_URL;
      if (redirectTo.editMode) {
        state = {
          viewMode: _public.ViewMode.EDIT
        };
      }
    } else {
      path = (0, _dashboard_constants.createDashboardListingFilterUrl)(redirectTo.filter);
    }
    _kibana_services.coreServices.application.navigateToApp(_dashboard_constants.DASHBOARD_APP_ID, {
      path: `#/${path}`,
      state,
      replace: redirectTo.useReplace
    });
  };
  const getDashboardEmbedSettings = routeParams => {
    return {
      forceShowTopNavMenu: routeParams[dashboardUrlParams.showTopMenu] === 'true',
      forceShowQueryInput: routeParams[dashboardUrlParams.showQueryInput] === 'true',
      forceShowDatePicker: routeParams[dashboardUrlParams.showTimeFilter] === 'true',
      forceHideFilterBar: routeParams[dashboardUrlParams.hideFilterBar] === 'true'
    };
  };
  const renderDashboard = routeProps => {
    const routeParams = (0, _queryString.parse)(routeProps.history.location.search);
    if (routeParams.embed === 'true' && !globalEmbedSettings) {
      globalEmbedSettings = getDashboardEmbedSettings(routeParams);
    }
    return /*#__PURE__*/_react.default.createElement(_dashboard_app2.DashboardApp, {
      history: routeProps.history,
      embedSettings: globalEmbedSettings,
      savedDashboardId: routeProps.match.params.id,
      redirectTo: redirect,
      expandedPanelId: routeProps.match.params.expandedPanelId
    });
  };
  const renderListingPage = routeProps => {
    _kibana_services.coreServices.chrome.docTitle.change((0, _dashboard_app_strings.getDashboardPageTitle)());
    const routeParams = (0, _queryString.parse)(routeProps.history.location.search);
    const title = routeParams.title || undefined;
    const filter = routeParams.filter || undefined;
    return /*#__PURE__*/_react.default.createElement(_dashboard_listing_page.DashboardListingPage, {
      initialFilter: filter,
      title: title,
      kbnUrlStateStorage: getUrlStateStorage(routeProps.history),
      redirectTo: redirect
    });
  };
  const renderNoMatch = routeProps => {
    return /*#__PURE__*/_react.default.createElement(_dashboard_no_match.DashboardNoMatch, {
      history: routeProps.history
    });
  };
  const hasEmbeddableIncoming = Boolean(_kibana_services.embeddableService.getStateTransfer().getIncomingEmbeddablePackage(_dashboard_constants.DASHBOARD_APP_ID, false));
  if (!hasEmbeddableIncoming) {
    _kibana_services.dataService.dataViews.clearCache();
  }

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlistenParentHistory = mountContext.scopedHistory().listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  const app = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_dashboard_mount_context.DashboardMountContext.Provider, {
    value: mountContext
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.HashRouter, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: [_dashboard_constants.CREATE_NEW_DASHBOARD_URL, `${_dashboard_constants.VIEW_DASHBOARD_URL}/:id/:expandedPanelId`, `${_dashboard_constants.VIEW_DASHBOARD_URL}/:id`],
    render: renderDashboard
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _dashboard_constants.LANDING_PAGE_PATH,
    render: renderListingPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _dashboard_constants.LANDING_PAGE_PATH
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: renderNoMatch
  })))));
  _kibana_services.coreServices.chrome.setHelpExtension({
    appName: (0, _dashboard_app_strings.getDashboardPageTitle)(),
    links: [{
      linkType: 'documentation',
      href: `${_kibana_services.coreServices.docLinks.links.dashboard.guide}`
    }]
  });
  if (!(0, _get_dashboard_capabilities.getDashboardCapabilities)().showWriteControls) {
    _kibana_services.coreServices.chrome.setBadge({
      text: _dashboard_app_strings.dashboardReadonlyBadge.getText(),
      tooltip: _dashboard_app_strings.dashboardReadonlyBadge.getTooltip(),
      iconType: 'glasses'
    });
  }
  (0, _reactDom.render)(app, element);
  return () => {
    _kibana_services.dataService.search.session.clear();
    unlistenParentHistory();
    (0, _reactDom.unmountComponentAtNode)(element);
    appUnMounted();
  };
}