"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeUnsavedChanges = initializeUnsavedChanges;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeUnsavedChanges(anyMigrationRun, lastSavedInput) {
  const hasRunMigrations$ = new _rxjs.BehaviorSubject(anyMigrationRun);
  const hasUnsavedChanges$ = new _rxjs.BehaviorSubject(false);
  const lastSavedInput$ = new _rxjs.BehaviorSubject(lastSavedInput);
  return {
    hasRunMigrations$,
    hasUnsavedChanges$,
    lastSavedInput$,
    setHasUnsavedChanges: hasUnsavedChanges => hasUnsavedChanges$.next(hasUnsavedChanges),
    setLastSavedInput: input => {
      lastSavedInput$.next(input);

      // if we set the last saved input, it means we have saved this Dashboard - therefore clientside migrations have
      // been serialized into the SO.
      hasRunMigrations$.next(false);
    }
  };
}