"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeTrackPanel = initializeTrackPanel;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeTrackPanel(untilEmbeddableLoaded) {
  const expandedPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const focusedPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const highlightPanelId$ = new _rxjs.BehaviorSubject(undefined);
  const scrollToPanelId$ = new _rxjs.BehaviorSubject(undefined);
  let scrollPosition;
  function setScrollToPanelId(id) {
    if (scrollToPanelId$.value !== id) scrollToPanelId$.next(id);
  }
  function setExpandedPanelId(id) {
    if (expandedPanelId$.value !== id) expandedPanelId$.next(id);
  }
  return {
    expandedPanelId: expandedPanelId$,
    expandPanel: panelId => {
      const isPanelExpanded = Boolean(expandedPanelId$.value);
      if (isPanelExpanded) {
        setExpandedPanelId(undefined);
        setScrollToPanelId(panelId);
        return;
      }
      setExpandedPanelId(panelId);
      if (window.scrollY > 0) {
        scrollPosition = window.scrollY;
      }
    },
    focusedPanelId$,
    highlightPanelId$,
    highlightPanel: panelRef => {
      const id = highlightPanelId$.value;
      if (id && panelRef) {
        untilEmbeddableLoaded(id).then(() => {
          panelRef.classList.add('dshDashboardGrid__item--highlighted');
          // Removes the class after the highlight animation finishes
          setTimeout(() => {
            panelRef.classList.remove('dshDashboardGrid__item--highlighted');
          }, 5000);
        });
      }
      highlightPanelId$.next(undefined);
    },
    scrollToPanelId$,
    scrollToPanel: async panelRef => {
      const id = scrollToPanelId$.value;
      if (!id) return;
      untilEmbeddableLoaded(id).then(() => {
        setScrollToPanelId(undefined);
        if (scrollPosition) {
          panelRef.ontransitionend = () => {
            // Scroll to the last scroll position after the transition ends to ensure the panel is back in the right position before scrolling
            // This is necessary because when an expanded panel collapses, it takes some time for the panel to return to its original position
            window.scrollTo({
              top: scrollPosition
            });
            scrollPosition = undefined;
            panelRef.ontransitionend = null;
          };
          return;
        }
        panelRef.scrollIntoView({
          block: 'nearest'
        });
      });
    },
    scrollToTop: () => {
      window.scroll(0, 0);
    },
    setExpandedPanelId,
    setFocusedPanelId: id => {
      if (focusedPanelId$.value !== id) focusedPanelId$.next(id);
      setScrollToPanelId(id);
    },
    setHighlightPanelId: id => {
      if (highlightPanelId$.value !== id) highlightPanelId$.next(id);
    },
    setScrollToPanelId
  };
}