"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardApi = getDashboardApi;
var _rxjs = require("rxjs");
var _track_panel = require("./track_panel");
var _track_overlay = require("./track_overlay");
var _unsaved_changes = require("./unsaved_changes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardApi(initialComponentState, untilEmbeddableLoaded) {
  const animatePanelTransforms$ = new _rxjs.BehaviorSubject(false); // set panel transforms to false initially to avoid panels animating on initial render.
  const fullScreenMode$ = new _rxjs.BehaviorSubject(initialComponentState.fullScreenMode);
  const managed$ = new _rxjs.BehaviorSubject(initialComponentState.managed);
  const savedObjectId$ = new _rxjs.BehaviorSubject(initialComponentState.lastSavedId);
  const trackPanel = (0, _track_panel.initializeTrackPanel)(untilEmbeddableLoaded);
  return {
    ...trackPanel,
    ...(0, _track_overlay.initializeTrackOverlay)(trackPanel.setFocusedPanelId),
    ...(0, _unsaved_changes.initializeUnsavedChanges)(initialComponentState.anyMigrationRun, initialComponentState.lastSavedInput),
    animatePanelTransforms$,
    fullScreenMode$,
    isEmbeddedExternally: initialComponentState.isEmbeddedExternally,
    managed$,
    savedObjectId: savedObjectId$,
    setAnimatePanelTransforms: animate => animatePanelTransforms$.next(animate),
    setFullScreenMode: fullScreenMode => fullScreenMode$.next(fullScreenMode),
    setManaged: managed => managed$.next(managed),
    setSavedObjectId: id => savedObjectId$.next(id)
  };
}