"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyUnlinkActionIsCompatible = exports.LegacyUnlinkFromLibraryAction = exports.ACTION_LEGACY_UNLINK_FROM_LIBRARY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_LEGACY_UNLINK_FROM_LIBRARY = exports.ACTION_LEGACY_UNLINK_FROM_LIBRARY = 'legacyUnlinkFromLibrary';
const legacyUnlinkActionIsCompatible = api => Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasLegacyLibraryTransforms)(api));
exports.legacyUnlinkActionIsCompatible = legacyUnlinkActionIsCompatible;
class LegacyUnlinkFromLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_LEGACY_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "id", ACTION_LEGACY_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 15);
  }
  getDisplayName({
    embeddable
  }) {
    if (!legacyUnlinkActionIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!legacyUnlinkActionIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'folderExclamation';
  }
  async isCompatible({
    embeddable
  }) {
    if (!legacyUnlinkActionIsCompatible(embeddable)) return false;
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && (await embeddable.canUnlinkFromLibrary());
  }
  async execute({
    embeddable
  }) {
    if (!legacyUnlinkActionIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const title = (0, _presentationPublishing.getPanelTitle)(embeddable);
    try {
      await embeddable.unlinkFromLibrary();
      _kibana_services.coreServices.notifications.toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getSuccessMessage(title ? `'${title}'` : ''),
        'data-test-subj': 'unlinkPanelSuccess'
      });
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getFailureMessage(title ? `'${title}'` : ''),
        'data-test-subj': 'unlinkPanelFailure'
      });
    }
  }
}
exports.LegacyUnlinkFromLibraryAction = LegacyUnlinkFromLibraryAction;