"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToDashboardAction = exports.ACTION_COPY_TO_DASHBOARD = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/ui-actions-plugin/public");
var _dashboard_container = require("../dashboard_container");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _copy_to_dashboard_modal = require("./copy_to_dashboard_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_COPY_TO_DASHBOARD = exports.ACTION_COPY_TO_DASHBOARD = 'copyToDashboard';
const apiIsCompatible = api => {
  var _api$parentApi;
  return (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiIsOfType)(api.parentApi, _dashboard_container.DASHBOARD_CONTAINER_TYPE) && (api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.getDashboardPanelFromId) !== undefined && (0, _presentationPublishing.apiPublishesSavedObjectId)(api.parentApi);
};
class CopyToDashboardAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "id", ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "order", 1);
  }
  getDisplayName({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'exit';
  }
  async isCompatible({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) return false;
    const {
      createNew: canCreateNew,
      showWriteControls: canEditExisting
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    return Boolean(canCreateNew || canEditExisting);
  }
  async execute({
    embeddable
  }) {
    if (!apiIsCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const {
      theme,
      i18n
    } = _kibana_services.coreServices;
    const session = _kibana_services.coreServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_copy_to_dashboard_modal.CopyToDashboardModal, {
      closeModal: () => session.close(),
      api: embeddable
    }), {
      theme,
      i18n
    }), {
      maxWidth: 400,
      'data-test-subj': 'copyToDashboardPanel'
    });
  }
}
exports.CopyToDashboardAction = CopyToDashboardAction;