"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserSettingsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const userSettingsDataPath = 'userSettings';

/**
 * @internal
 */

/**
 * @internal
 */
class UserSettingsService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "userProfile", void 0);
    this.logger = coreContext.logger.get('user-settings-service');
  }
  setup() {
    return {
      getUserSettingDarkMode: async request => {
        const userSettings = await this.getSettings(request);
        return getUserSettingDarkMode(userSettings);
      }
    };
  }
  start(deps) {
    this.userProfile = deps.userProfile;
  }
  async getSettings(request) {
    if (this.userProfile) {
      var _userProfile$data$use, _userProfile$data;
      const userProfile = await this.userProfile.getCurrent({
        request,
        dataPath: userSettingsDataPath
      });
      return (_userProfile$data$use = userProfile === null || userProfile === void 0 ? void 0 : (_userProfile$data = userProfile.data) === null || _userProfile$data === void 0 ? void 0 : _userProfile$data[userSettingsDataPath]) !== null && _userProfile$data$use !== void 0 ? _userProfile$data$use : {};
    } else {
      this.logger.debug('userProfile not set');
      return {};
    }
  }
}
exports.UserSettingsService = UserSettingsService;
const getUserSettingDarkMode = userSettings => {
  if (userSettings !== null && userSettings !== void 0 && userSettings.darkMode) {
    return userSettings.darkMode.toUpperCase() === 'DARK';
  }
  return undefined;
};