"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialState = void 0;
var Option = _interopRequireWildcard(require("fp-ts/Option"));
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _get_outdated_documents_query = require("./get_outdated_documents_query");
var _core = require("./core");
var _helpers = require("./model/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TEMP_INDEX_MAPPINGS = {
  dynamic: false,
  properties: {
    type: {
      type: 'keyword'
    },
    typeMigrationVersion: {
      type: 'version'
    }
  }
};

/**
 * Construct the initial state for the model
 */
const createInitialState = ({
  kibanaVersion,
  waitForMigrationCompletion,
  mustRelocateDocuments,
  indexTypes,
  indexTypesMap,
  hashToVersionMap,
  targetIndexMappings,
  preMigrationScript,
  coreMigrationVersionPerType,
  migrationVersionPerType,
  indexPrefix,
  migrationsConfig,
  typeRegistry,
  docLinks,
  logger,
  esCapabilities
}) => {
  const outdatedDocumentsQuery = (0, _get_outdated_documents_query.getOutdatedDocumentsQuery)({
    coreMigrationVersionPerType,
    migrationVersionPerType
  });
  const knownTypes = typeRegistry.getAllTypes().map(type => type.name);
  const excludeFilterHooks = Object.fromEntries(typeRegistry.getAllTypes().filter(type => !!type.excludeOnUpgrade).map(type => [type.name, type.excludeOnUpgrade]));
  // short key to access savedObjects entries directly from docLinks
  const migrationDocLinks = docLinks.links.kibanaUpgradeSavedObjects;
  if (migrationsConfig.discardUnknownObjects && migrationsConfig.discardUnknownObjects !== kibanaVersion) {
    logger.warn('The flag `migrations.discardUnknownObjects` is defined but does not match the current kibana version; unknown objects will NOT be discarded.');
  }
  if (migrationsConfig.discardCorruptObjects && migrationsConfig.discardCorruptObjects !== kibanaVersion) {
    logger.warn('The flag `migrations.discardCorruptObjects` is defined but does not match the current kibana version; corrupt objects will NOT be discarded.');
  }
  return {
    controlState: 'INIT',
    waitForMigrationCompletion,
    mustRelocateDocuments,
    indexTypes,
    indexTypesMap,
    hashToVersionMap,
    indexPrefix,
    legacyIndex: indexPrefix,
    currentAlias: indexPrefix,
    versionAlias: `${indexPrefix}_${kibanaVersion}`,
    versionIndex: `${indexPrefix}_${kibanaVersion}_001`,
    tempIndex: (0, _helpers.getTempIndexName)(indexPrefix, kibanaVersion),
    tempIndexAlias: (0, _helpers.getTempIndexName)(indexPrefix, kibanaVersion) + '_alias',
    kibanaVersion,
    preMigrationScript: Option.fromNullable(preMigrationScript),
    targetIndexMappings,
    tempIndexMappings: TEMP_INDEX_MAPPINGS,
    outdatedDocumentsQuery,
    retryCount: 0,
    retryDelay: 0,
    retryAttempts: migrationsConfig.retryAttempts,
    batchSize: migrationsConfig.batchSize,
    maxBatchSize: migrationsConfig.batchSize,
    maxBatchSizeBytes: migrationsConfig.maxBatchSizeBytes.getValueInBytes(),
    maxReadBatchSizeBytes: migrationsConfig.maxReadBatchSizeBytes.getValueInBytes(),
    discardUnknownObjects: migrationsConfig.discardUnknownObjects === kibanaVersion,
    discardCorruptObjects: migrationsConfig.discardCorruptObjects === kibanaVersion,
    logs: [],
    excludeOnUpgradeQuery: _core.excludeUnusedTypesQuery,
    knownTypes,
    latestMappingsVersions: (0, _coreSavedObjectsBaseServerInternal.getLatestMappingsVirtualVersionMap)(typeRegistry.getAllTypes()),
    excludeFromUpgradeFilterHooks: excludeFilterHooks,
    migrationDocLinks,
    esCapabilities
  };
};
exports.createInitialState = createInitialState;