"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryWindow = void 0;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** We .ceil to rather _slightly_ over-report usage in certain circumstances */
const twoDeci = num => Math.ceil(num * 100) / 100;
var _window = /*#__PURE__*/new WeakMap();
var _size = /*#__PURE__*/new WeakMap();
class HistoryWindow {
  constructor(size) {
    _classPrivateFieldInitSpec(this, _window, void 0);
    _classPrivateFieldInitSpec(this, _size, void 0);
    _classPrivateFieldSet(_size, this, size);
    _classPrivateFieldSet(_window, this, new Array(_classPrivateFieldGet(_size, this)).fill(0));
  }
  get size() {
    return _classPrivateFieldGet(_window, this).length;
  }
  addObservation(value) {
    _classPrivateFieldGet(_window, this).unshift(Math.max(0, value));
    _classPrivateFieldGet(_window, this).pop();
  }

  /**
   * @param includeObservations number of observations to include in calculation. Will be normalized to be within the window size.
   */
  getAverage(includeObservations) {
    includeObservations = Math.min(Math.max(1, includeObservations), this.size);
    return twoDeci(_classPrivateFieldGet(_window, this).slice(0, includeObservations).reduce((acc, val) => acc + val, 0) / includeObservations);
  }
}
exports.HistoryWindow = HistoryWindow;