"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEluHistoryRoute = registerEluHistoryRoute;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _history_window = require("./history_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HISTORY_WINDOW_SIZE_SHORT = 3;
const HISTORY_WINDOW_SIZE_MED = 6;
const HISTORY_WINDOW_SIZE_LONG = 12;

/**
 * Intended for exposing metrics over HTTP that we do not want to include in the /api/stats endpoint, yet.
 */
function registerEluHistoryRoute(router, metrics$) {
  const eluHistoryWindow = new _history_window.HistoryWindow(HISTORY_WINDOW_SIZE_LONG);
  metrics$.subscribe(metrics => {
    eluHistoryWindow.addObservation(metrics.process.event_loop_utilization.utilization);
  });

  // Report the same metrics to APM
  _elasticApmNode.default.registerMetric('elu.history.short', () => eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_SHORT));
  _elasticApmNode.default.registerMetric('elu.history.medium', () => eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_MED));
  _elasticApmNode.default.registerMetric('elu.history.long', () => eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_LONG));
  router.versioned.get({
    access: 'internal',
    enableQueryVersion: true,
    path: '/api/_elu_history',
    options: {
      authRequired: false
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (ctx, req, res) => {
    const body = {
      history: {
        short: eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_SHORT),
        medium: eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_MED),
        long: eluHistoryWindow.getAverage(HISTORY_WINDOW_SIZE_LONG)
      }
    };
    return res.ok({
      body
    });
  });
}