"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpsMetricsCollector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreMetricsCollectorsServerInternal = require("@kbn/core-metrics-collectors-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class OpsMetricsCollector {
  constructor(server, agentStatsProvider, opsOptions) {
    (0, _defineProperty2.default)(this, "processCollector", void 0);
    (0, _defineProperty2.default)(this, "osCollector", void 0);
    (0, _defineProperty2.default)(this, "serverCollector", void 0);
    (0, _defineProperty2.default)(this, "esClientCollector", void 0);
    this.processCollector = new _coreMetricsCollectorsServerInternal.ProcessMetricsCollector();
    this.osCollector = new _coreMetricsCollectorsServerInternal.OsMetricsCollector(opsOptions);
    this.serverCollector = new _coreMetricsCollectorsServerInternal.ServerMetricsCollector(server);
    this.esClientCollector = new _coreMetricsCollectorsServerInternal.ElasticsearchClientsMetricsCollector(agentStatsProvider);
  }
  async collect() {
    const [processes, os, esClient, server] = await Promise.all([this.processCollector.collect(), this.osCollector.collect(), this.esClientCollector.collect(), this.serverCollector.collect()]);
    return {
      collected_at: new Date(),
      /**
       * Kibana does not yet support multi-process nodes.
       * `processes` is just an Array(1) only returning the current process's data
       *  which is why we can just use processes[0] for `process`
       */
      process: processes[0],
      processes,
      os,
      elasticsearch_client: esClient,
      ...server
    };
  }
  reset() {
    this.processCollector.reset();
    this.osCollector.reset();
    this.serverCollector.reset();
  }
}
exports.OpsMetricsCollector = OpsMetricsCollector;