"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validBodyOutput = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The set of valid body.output
 * @public
 */
const validBodyOutput = exports.validBodyOutput = ['data', 'stream'];

/**
 * Set of HTTP methods changing the state of the server.
 * @public
 */

/**
 * Set of HTTP methods not changing the state of the server.
 * @public
 */

/**
 * The set of common HTTP methods supported by Kibana routing.
 * @public
 */

/**
 * The set of supported parseable Content-Types
 * @public
 */

/**
 * Additional body options for a route
 * @public
 */

/**
 * Route access level.
 *
 * Public routes are stable and intended for external access and are subject to
 * stricter change management and have long term maintenance windows.
 *
 * @remark as of 9.0, access to internal routes is restricted by default. See https://github.com/elastic/kibana/issues/163654.
 */

/**
 * A set of privileges that can be used to define complex authorization requirements.
 *
 * - `anyRequired`: An array of privileges where at least one must be satisfied to meet the authorization requirement.
 * - `allRequired`: An array of privileges where all listed privileges must be satisfied to meet the authorization requirement.
 */

/**
 * An array representing a combination of simple privileges or complex privilege sets.
 */

/**
 * Describes the authorization requirements when authorization is enabled.
 *
 * - `requiredPrivileges`: An array of privileges or privilege sets that are required for the route.
 */

/**
 * Describes the state when authorization is disabled.
 *
 * - `enabled`: A boolean indicating that authorization is not enabled (`false`).
 * - `reason`: A string explaining why authorization is disabled.
 */

/**
 * Describes the authentication status when authentication is enabled.
 *
 * - `enabled`: A boolean or string indicating the authentication status. Can be `true` (authentication required) or `'optional'` (authentication is optional).
 */

/**
 * Describes the state when authentication is disabled.
 *
 * - `enabled`: A boolean indicating that authentication is not enabled (`false`).
 * - `reason`: A string explaining why authentication is disabled.
 */

/**
 * Represents the authentication status for a route. It can either be enabled (`AuthcEnabled`) or disabled (`AuthcDisabled`).
 */

/**
 * Represents the authorization status for a route. It can either be enabled (`AuthzEnabled`) or disabled (`AuthzDisabled`).
 */

/**
 * Describes the security requirements for a route, including authorization and authentication.
 */

/**
 * Additional route options.
 * @public
 */

/**
 * Route specific configuration.
 * @public
 */