"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializableRuntimeStateToControlGroupSerializedState = exports.getDefaultControlGroupState = exports.controlGroupSerializedStateToSerializableRuntimeState = void 0;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDefaultControlGroupState = () => ({
  panels: {},
  labelPosition: _common.DEFAULT_CONTROL_LABEL_POSITION,
  chainingSystem: 'HIERARCHICAL',
  autoApplySelections: true,
  ignoreParentSettings: {
    ignoreFilters: false,
    ignoreQuery: false,
    ignoreTimerange: false,
    ignoreValidations: false
  }
});

// using SerializableRecord to force type to be read as serializable
exports.getDefaultControlGroupState = getDefaultControlGroupState;
const safeJSONParse = jsonString => {
  if (!jsonString && typeof jsonString !== 'string') return;
  try {
    return JSON.parse(jsonString);
  } catch {
    return;
  }
};
const controlGroupSerializedStateToSerializableRuntimeState = serializedState => {
  var _serializedState$cont, _safeJSONParse, _safeJSONParse2;
  const defaultControlGroupInput = getDefaultControlGroupState();
  return {
    chainingSystem: serializedState === null || serializedState === void 0 ? void 0 : serializedState.chainingSystem,
    labelPosition: (_serializedState$cont = serializedState === null || serializedState === void 0 ? void 0 : serializedState.controlStyle) !== null && _serializedState$cont !== void 0 ? _serializedState$cont : defaultControlGroupInput.labelPosition,
    autoApplySelections: !(serializedState !== null && serializedState !== void 0 && serializedState.showApplySelections),
    ignoreParentSettings: (_safeJSONParse = safeJSONParse(serializedState === null || serializedState === void 0 ? void 0 : serializedState.ignoreParentSettingsJSON)) !== null && _safeJSONParse !== void 0 ? _safeJSONParse : {},
    panels: (_safeJSONParse2 = safeJSONParse(serializedState === null || serializedState === void 0 ? void 0 : serializedState.panelsJSON)) !== null && _safeJSONParse2 !== void 0 ? _safeJSONParse2 : {}
  };
};
exports.controlGroupSerializedStateToSerializableRuntimeState = controlGroupSerializedStateToSerializableRuntimeState;
const serializableRuntimeStateToControlGroupSerializedState = serializable => {
  return {
    controlStyle: serializable.labelPosition,
    chainingSystem: serializable.chainingSystem,
    showApplySelections: !Boolean(serializable.autoApplySelections),
    ignoreParentSettingsJSON: JSON.stringify(serializable.ignoreParentSettings),
    panelsJSON: JSON.stringify(serializable.panels)
  };
};
exports.serializableRuntimeStateToControlGroupSerializedState = serializableRuntimeStateToControlGroupSerializedState;