"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsPlugin = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _clear_control_action = require("./actions/clear_control_action");
var _delete_control_action = require("./actions/delete_control_action");
var _edit_control_action = require("./actions/edit_control_action");
var _register_control_group_embeddable = require("./control_group/register_control_group_embeddable");
var _register_options_list_control = require("./controls/data_controls/options_list_control/register_options_list_control");
var _register_range_slider_control = require("./controls/data_controls/range_slider/register_range_slider_control");
var _register_timeslider_control = require("./controls/timeslider_control/register_timeslider_control");
var _kibana_services = require("./services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ControlsPlugin {
  setup(_coreSetup, _setupPlugins) {
    const {
      embeddable
    } = _setupPlugins;
    (0, _register_control_group_embeddable.registerControlGroupEmbeddable)(embeddable);
    (0, _register_options_list_control.registerOptionsListControl)();
    (0, _register_range_slider_control.registerRangeSliderControl)();
    (0, _register_timeslider_control.registerTimeSliderControl)();
  }
  start(coreStart, startPlugins) {
    const {
      uiActions
    } = startPlugins;
    (0, _kibana_services.setKibanaServices)(coreStart, startPlugins);
    (0, _kibana_services.untilPluginStartServicesReady)().then(() => {
      const deleteControlAction = new _delete_control_action.DeleteControlAction();
      uiActions.registerAction(deleteControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, deleteControlAction.id);
      const editControlAction = new _edit_control_action.EditControlAction();
      uiActions.registerAction(editControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, editControlAction.id);
      const clearControlAction = new _clear_control_action.ClearControlAction();
      uiActions.registerAction(clearControlAction);
      uiActions.attachAction(_public.PANEL_HOVER_TRIGGER, clearControlAction.id);
    });
  }
  stop() {}
}
exports.ControlsPlugin = ControlsPlugin;